/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms.UpdateOperators;

import com.mongodb.MongoClient;
import io.debezium.connector.mongodb.transforms.AbstractUnwrapFromMongoDbEnvelopeTestIT;
import io.debezium.embedded.AbstractConnectorTest;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;

abstract class AbstractUnwrapFromMongoDbEnvelopeUpdateOperatorsTestIT
extends AbstractUnwrapFromMongoDbEnvelopeTestIT {
    AbstractUnwrapFromMongoDbEnvelopeUpdateOperatorsTestIT() {
    }

    @Override
    protected String getCollectionName() {
        return "update_operators";
    }

    SourceRecord executeSimpleUpdateOperation(String updateDocument) throws InterruptedException {
        this.primary().execute("insert", this.createInsertItemDefault(1));
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(this.topicName())).hasSize(1);
        this.primary().execute("update", this.createUpdateOneItem(1, updateDocument));
        return this.getUpdateRecord();
    }

    private Consumer<MongoClient> createInsertItemDefault(int id) {
        return client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).insertOne((Object)Document.parse((String)("{'_id': " + id + ",'dataStr': 'hello','dataInt': 123,'dataLong': 80000000000,'dataBoolean': true,'dataByte': -1,'dataArrayOfStr': ['a','c','e'],'nested': {'dataStr': 'hello','dataInt': 123,'dataLong': 80000000000,'dataBoolean': true,'dataByte': -1}}")));
    }

    private Consumer<MongoClient> createUpdateOneItem(int id, String document) {
        return client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)Document.parse((String)String.format("{'_id' : %d}", id)), (Bson)Document.parse((String)document));
    }
}

