/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoInterruptedException;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicaSetMonitorThread
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Metronome metronome;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final Supplier<ReplicaSets> monitor;
    private final Consumer<ReplicaSets> onChange;
    private final Runnable onStartup;
    private volatile ReplicaSets replicaSets = ReplicaSets.empty();

    public ReplicaSetMonitorThread(Supplier<ReplicaSets> monitor, long period, TimeUnit unit, Clock clock, Runnable onStartup, Consumer<ReplicaSets> onChange) {
        if (clock == null) {
            clock = Clock.system();
        }
        this.monitor = monitor;
        this.metronome = Metronome.sleeper((long)period, (TimeUnit)unit, (Clock)clock);
        this.onChange = onChange != null ? onChange : rsSpecs -> {};
        this.onStartup = onStartup != null ? onStartup : () -> {};
    }

    @Override
    public void run() {
        if (!Thread.currentThread().isInterrupted()) {
            this.onStartup.run();
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ReplicaSets previousReplicaSets = this.replicaSets;
                this.replicaSets = this.monitor.get();
                this.initialized.countDown();
                if (this.replicaSets.haveChangedSince(previousReplicaSets)) {
                    try {
                        this.onChange.accept(this.replicaSets);
                    }
                    catch (MongoInterruptedException t) {
                        this.logger.error("Interrupted while calling the function with the new replica set specifications", (Throwable)t);
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable t) {
                        this.logger.error("Error while calling the function with the new replica set specifications", t);
                    }
                }
            }
            catch (MongoInterruptedException t) {
                this.logger.error("interrupted while trying to get information about the replica sets", (Throwable)t);
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.logger.error("Error while trying to get information about the replica sets", t);
            }
            if (Thread.currentThread().isInterrupted()) continue;
            try {
                this.metronome.pause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ReplicaSets getReplicaSets(long timeout, TimeUnit unit) {
        try {
            if (this.initialized.await(timeout, unit)) {
                return this.replicaSets;
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        return null;
    }
}

