/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoDatabase;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    protected static final Logger logger = LoggerFactory.getLogger(TestHelper.class);

    public static Configuration getConfiguration() {
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.fromSystemProperties((String)"connector.").edit().withDefault(MongoDbConnectorConfig.HOSTS, "rs0/localhost:27017")).withDefault(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, false)).withDefault(MongoDbConnectorConfig.LOGICAL_NAME, "mongo1")).build();
    }

    public static void cleanDatabase(ConnectionContext.MongoPrimary primary, String dbName) {
        primary.execute("clean-db", mongo -> {
            MongoDatabase db1 = mongo.getDatabase(dbName);
            db1.listCollectionNames().forEach(x -> {
                logger.info("Removing collection '{}' from database '{}'", x, (Object)dbName);
                db1.getCollection(x).drop();
            });
        });
    }
}

