/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbTopicSelector;
import io.debezium.connector.mongodb.RecordMakers;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.transforms.UnwrapFromMongoDbEnvelope;
import io.debezium.doc.FixFor;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Collect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UnwrapFromMongoDbEnvelopeTest {
    private static final String SERVER_NAME = "serverX";
    private static final String FLATTEN_STRUCT = "flatten.struct";
    private static final String DELIMITER = "flatten.struct.delimiter";
    private SourceInfo source;
    private RecordMakers recordMakers;
    private TopicSelector<CollectionId> topicSelector;
    private List<SourceRecord> produced;
    private UnwrapFromMongoDbEnvelope<SourceRecord> transformation;

    @Before
    public void setup() {
        this.source = new SourceInfo(SERVER_NAME);
        this.topicSelector = MongoDbTopicSelector.defaultSelector((String)SERVER_NAME, (String)"__debezium-heartbeat");
        this.produced = new ArrayList<SourceRecord>();
        this.recordMakers = new RecordMakers(this.source, this.topicSelector, this.produced::add, true);
        this.transformation = new UnwrapFromMongoDbEnvelope();
        this.transformation.configure(Collections.singletonMap("array.encoding", "array"));
    }

    @After
    public void closeSmt() {
        this.transformation.close();
    }

    @Test
    public void shouldTransformRecordForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"i");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((String)value.schema().name()).isEqualTo((Object)"serverX.dbA.c1");
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)value.get("name")).isEqualTo((Object)"Sally");
        Assertions.assertThat((Object)value.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.get("phone")).isEqualTo((Object)123L);
        Assertions.assertThat((Object)value.get("active")).isEqualTo((Object)true);
        Assertions.assertThat((Object)value.get("scores")).isEqualTo(Arrays.asList(1.2, 3.4, 5.6));
        Assertions.assertThat((Object)value.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("phone").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_INT64_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("active").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_BOOLEAN_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("scores").schema()).isEqualTo((Object)SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_FLOAT64_SCHEMA).optional().build());
        Assertions.assertThat((List)value.schema().fields()).hasSize(5);
        this.transformation.close();
    }

    @Test
    public void shouldTransformRecordForInsertEventWithComplexIdType() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        Document obj = new Document().append("_id", (Object)new Document().append("company", (Object)32).append("dept", (Object)"home improvement")).append("name", (Object)"Sally");
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"i");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema().field("company").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)key.schema().field("id").schema().field("dept").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)((Struct)key.get("id")).get("company")).isEqualTo((Object)32);
        Assertions.assertThat((Object)((Struct)key.get("id")).get("dept")).isEqualTo((Object)"home improvement");
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)((Struct)value.get("id")).get("company")).isEqualTo((Object)32);
        Assertions.assertThat((Object)((Struct)value.get("id")).get("dept")).isEqualTo((Object)"home improvement");
        Assertions.assertThat((Object)value.get("name")).isEqualTo((Object)"Sally");
        Assertions.assertThat((Object)value.schema().field("id").schema().field("company").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("id").schema().field("dept").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((List)value.schema().fields()).hasSize(2);
        this.transformation.close();
    }

    @Test
    public void shouldGenerateRecordForUpdateEvent() throws InterruptedException {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document("name", (Object)"Sally"));
        Document event = new Document().append("o", (Object)obj).append("o2", (Object)objId).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"u");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)value.get("name")).isEqualTo((Object)"Sally");
        Assertions.assertThat((Object)value.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((List)value.schema().fields()).hasSize(2);
    }

    @Test
    @FixFor(value={"DBZ-582"})
    public void shouldGenerateRecordForDeleteEventWithoutTombstone() throws InterruptedException {
        RecordMakers recordMakers = new RecordMakers(this.source, this.topicSelector, this.produced::add, false);
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"d");
        RecordMakers.RecordsForCollection records = recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value).isNull();
    }

    @Test
    public void shouldGenerateRecordForDeleteEvent() throws InterruptedException {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"d");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(2);
        SourceRecord record = this.produced.get(0);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value).isNull();
    }

    @Test
    public void shouldNotFlattenTransformRecordForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        ObjectId objId = new ObjectId();
        Document address = new Document().append("street", (Object)"Morris Park Ave").append("zipcode", (Object)"10462");
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("address", (Object)address);
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"i");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)value.get("name")).isEqualTo((Object)"Sally");
        Assertions.assertThat((Object)value.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.get("address")).isEqualTo((Object)new Struct(value.schema().field("address").schema()).put("street", (Object)"Morris Park Ave").put("zipcode", (Object)"10462"));
        Assertions.assertThat((Object)value.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address").schema()).isEqualTo((Object)SchemaBuilder.struct().name("serverX.dbA.c1.address").optional().field("street", Schema.OPTIONAL_STRING_SCHEMA).field("zipcode", Schema.OPTIONAL_STRING_SCHEMA).build());
        Assertions.assertThat((List)value.schema().fields()).hasSize(3);
        this.transformation.close();
    }

    @Test
    public void shouldFlattenTransformRecordForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        ObjectId objId = new ObjectId();
        Document address = new Document().append("street", (Object)"Morris Park Ave").append("zipcode", (Object)"10462");
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("address", (Object)address);
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"i");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(FLATTEN_STRUCT, "true");
        this.transformation.configure(props);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)value.get("name")).isEqualTo((Object)"Sally");
        Assertions.assertThat((Object)value.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.get("address_street")).isEqualTo((Object)"Morris Park Ave");
        Assertions.assertThat((Object)value.get("address_zipcode")).isEqualTo((Object)"10462");
        Assertions.assertThat((Object)value.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address_street").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address_zipcode").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((List)value.schema().fields()).hasSize(4);
        this.transformation.close();
    }

    @Test
    public void shouldFlattenWithDelimiterTransformRecordForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        ObjectId objId = new ObjectId();
        Document address = new Document().append("street", (Object)"Morris Park Ave").append("zipcode", (Object)"10462");
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("address", (Object)address);
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"i");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(FLATTEN_STRUCT, "true");
        props.put(DELIMITER, "-");
        this.transformation.configure(props);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)value.get("name")).isEqualTo((Object)"Sally");
        Assertions.assertThat((Object)value.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.get("address-street")).isEqualTo((Object)"Morris Park Ave");
        Assertions.assertThat((Object)value.get("address-zipcode")).isEqualTo((Object)"10462");
        Assertions.assertThat((Object)value.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address-street").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address-zipcode").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((List)value.schema().fields()).hasSize(4);
        this.transformation.close();
    }

    @Test
    public void shouldFlattenWithDelimiterTransformRecordForUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document(Collect.hashMapOf((Object)"address.city", (Object)"Canberra", (Object)"address.name", (Object)"James", (Object)"address.city2.part", (Object)3)));
        Document event = new Document().append("o", (Object)obj).append("o2", (Object)objId).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"u");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(FLATTEN_STRUCT, "true");
        props.put(DELIMITER, "-");
        this.transformation.configure(props);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)record);
        Struct key = (Struct)transformed.key();
        Struct value = (Struct)transformed.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)transformed.keySchema());
        Assertions.assertThat((Object)key.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)key.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)transformed.valueSchema());
        Assertions.assertThat((Object)value.get("id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.get("address-city")).isEqualTo((Object)"Canberra");
        Assertions.assertThat((Object)value.get("address-name")).isEqualTo((Object)"James");
        Assertions.assertThat((Object)value.get("address-city2-part")).isEqualTo((Object)3);
        Assertions.assertThat((Object)value.schema().field("id").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address-city").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address-name").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)value.schema().field("address-city2-part").schema()).isEqualTo((Object)SchemaBuilder.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((List)value.schema().fields()).hasSize(4);
        this.transformation.close();
    }
}

