/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.connector.mongodb.transforms.UnwrapFromMongoDbEnvelope;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.BsonDocument;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class MongoArrayConverterTest {
    private static final String HETEROGENOUS_ARRAY = "{\n    \"_id\": 1,\n    \"a2\": [\n        11,\n        \"abc\"\n    ]\n}";
    private static final String EMPTY_ARRAY = "{\n    \"_id\": 1,\n    \"f\": []\n}";
    private static final String HETEROGENOUS_DOCUMENT_IN_ARRAY = "{\n    \"_id\": 1,\n    \"a1\": [\n        {\n            \"a\": 1\n        },\n        {\n            \"a\": \"c\"\n        }\n    ],\n}";
    private static final String HOMOGENOUS_ARRAYS = "{\n    \"_id\": 1,\n    \"a1\": [\n        {\n            \"a\": 1\n        },\n        {\n            \"b\": \"c\"\n        }\n    ],\n    \"a2\": [\n        \"11\",\n        \"abc\"\n    ],\n    \"empty\": []\n}";
    private SchemaBuilder builder;

    @Before
    public void setup() throws Exception {
        this.builder = SchemaBuilder.struct().name("array");
    }

    @Test(expected=ConnectException.class)
    public void shouldDetectHeterogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
    }

    @Test(expected=ConnectException.class)
    public void shouldDetectHeterogenousDocumentInArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_DOCUMENT_IN_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
    }

    @Test
    public void shouldCreateSchemaForHomogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HOMOGENOUS_ARRAYS);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Assertions.assertThat((Object)finalSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("a1", SchemaBuilder.array((Schema)SchemaBuilder.struct().name("array.a1").optional().field("a", Schema.OPTIONAL_INT32_SCHEMA).field("b", Schema.OPTIONAL_STRING_SCHEMA).build()).optional().build()).field("a2", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).field("empty", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).build());
    }

    @Test
    public void shouldCreateStructForHomogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.ARRAY);
        BsonDocument val = BsonDocument.parse((String)HOMOGENOUS_ARRAYS);
        SchemaBuilder builder = SchemaBuilder.struct().name("array");
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, builder);
        }
        Schema finalSchema = builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : val.entrySet()) {
            converter.convertRecord(entry, finalSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,a1=[Struct{a=1}, Struct{b=c}],a2=[11, abc],empty=[]}");
    }

    @Test
    public void shouldCreateSchemaForEmptyArrayEncodingArray() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter arrayConverter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            arrayConverter.addFieldSchema(entry, this.builder);
        }
        Schema arraySchema = this.builder.build();
        Assertions.assertThat((Object)arraySchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("f", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build()).build());
    }

    @Test
    public void shouldCreateStructForEmptyArrayEncodingArray() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter arrayConverter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            arrayConverter.addFieldSchema(entry, this.builder);
        }
        Schema arraySchema = this.builder.build();
        Struct struct = new Struct(arraySchema);
        for (Map.Entry entry : val.entrySet()) {
            arrayConverter.convertRecord(entry, arraySchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,f=[]}");
    }

    @Test
    public void shouldCreateSchemaForEmptyArrayEncodingDocument() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter documentConverter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.DOCUMENT);
        for (Map.Entry entry : val.entrySet()) {
            documentConverter.addFieldSchema(entry, this.builder);
        }
        Schema documentSchema = this.builder.build();
        Assertions.assertThat((Object)documentSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("f", SchemaBuilder.struct().name("array.f").optional().build()).build());
    }

    @Test
    public void shouldCreateStructForEmptyArrayEncodingDocument() throws Exception {
        BsonDocument val = BsonDocument.parse((String)EMPTY_ARRAY);
        MongoDataConverter documentConverter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.DOCUMENT);
        for (Map.Entry entry : val.entrySet()) {
            documentConverter.addFieldSchema(entry, this.builder);
        }
        Schema documentSchema = this.builder.build();
        Struct struct = new Struct(documentSchema);
        for (Map.Entry entry : val.entrySet()) {
            documentConverter.convertRecord(entry, documentSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,f=Struct{}}");
    }

    @Test
    public void shouldCreateSchemaForHeterogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Assertions.assertThat((Object)finalSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("a2", SchemaBuilder.struct().name("array.a2").optional().field("_0", Schema.OPTIONAL_INT32_SCHEMA).field("_1", Schema.OPTIONAL_STRING_SCHEMA).build()).build());
    }

    @Test
    public void shouldCreateStructForHeterogenousArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : val.entrySet()) {
            converter.convertRecord(entry, finalSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,a2=Struct{_0=11,_1=abc}}");
    }

    @Test
    public void shouldCreateSchemaForHeterogenousDocumentInArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_DOCUMENT_IN_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Assertions.assertThat((Object)finalSchema).isEqualTo((Object)SchemaBuilder.struct().name("array").field("_id", Schema.OPTIONAL_INT32_SCHEMA).field("a1", SchemaBuilder.struct().name("array.a1").optional().field("_0", SchemaBuilder.struct().name("array.a1._0").optional().field("a", Schema.OPTIONAL_INT32_SCHEMA).build()).field("_1", SchemaBuilder.struct().name("array.a1._1").optional().field("a", Schema.OPTIONAL_STRING_SCHEMA).build()).build()).build());
    }

    @Test
    public void shouldCreateStructForHeterogenousDocumentInArray() throws Exception {
        MongoDataConverter converter = new MongoDataConverter(UnwrapFromMongoDbEnvelope.ArrayEncoding.DOCUMENT);
        BsonDocument val = BsonDocument.parse((String)HETEROGENOUS_DOCUMENT_IN_ARRAY);
        for (Map.Entry entry : val.entrySet()) {
            converter.addFieldSchema(entry, this.builder);
        }
        Schema finalSchema = this.builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : val.entrySet()) {
            converter.convertRecord(entry, finalSchema, struct);
        }
        Assertions.assertThat((String)struct.toString()).isEqualTo((Object)"Struct{_id=1,a1=Struct{_0=Struct{a=1},_1=Struct{a=c}}}");
    }
}

