/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.util.JSON;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoIT;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.Replicator;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.data.Envelope;
import io.debezium.data.VerifyRecord;
import io.debezium.util.Testing;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ReplicatorIT
extends AbstractMongoIT {
    @Test
    public void shouldReplicateContent() throws InterruptedException {
        Testing.Print.disable();
        this.useConfiguration(((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS, 1)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbA.contacts")).build());
        TestHelper.cleanDatabase(this.primary, "dbA");
        this.primary.execute("shouldCreateContactsDatabase", mongo -> {
            Testing.debug((Object)"Populating the 'dbA.contacts' collection");
            MongoDatabase db = mongo.getDatabase("dbA");
            MongoCollection contacts = db.getCollection("contacts");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            contacts.insertOne((Object)Document.parse((String)"{ \"name\":\"Jon Snow\"}"), insertOptions);
            Assertions.assertThat((long)db.getCollection("contacts").count()).isEqualTo(1L);
            Bson filter = Filters.eq((String)"name", (Object)"Jon Snow");
            FindIterable movieResults = db.getCollection("contacts").find(filter);
            try (MongoCursor cursor = movieResults.iterator();){
                Assertions.assertThat((String)((Document)cursor.tryNext()).getString((Object)"name")).isEqualTo((Object)"Jon Snow");
                Assertions.assertThat((Map)((Map)cursor.tryNext())).isNull();
            }
            Testing.debug((Object)"Completed document to 'dbA.contacts' collection");
        });
        LinkedList records = new LinkedList();
        Replicator replicator = new Replicator(this.context, this.replicaSet, records::add, x -> {});
        Thread thread = new Thread(() -> ((Replicator)replicator).run());
        thread.start();
        Thread.sleep(2000L);
        Object[] expectedNames = new Object[]{"Jon Snow", "Sally Hamm"};
        this.primary.execute("shouldCreateContactsDatabase", mongo -> {
            Testing.debug((Object)"Populating the 'dbA.contacts' collection");
            MongoDatabase db = mongo.getDatabase("dbA");
            MongoCollection contacts = db.getCollection("contacts");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            contacts.insertOne((Object)Document.parse((String)"{ \"name\":\"Sally Hamm\"}"), insertOptions);
            Assertions.assertThat((long)db.getCollection("contacts").count()).isEqualTo(2L);
            FindIterable movieResults = db.getCollection("contacts").find();
            HashSet<String> foundNames = new HashSet<String>();
            try (MongoCursor cursor = movieResults.iterator();){
                while (cursor.hasNext()) {
                    String name = ((Document)cursor.next()).getString((Object)"name");
                    foundNames.add(name);
                }
            }
            Assertions.assertThat(foundNames).containsOnly(expectedNames);
            Testing.debug((Object)"Completed document to 'dbA.contacts' collection");
        });
        int numEventsExpected = 2;
        long stop = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(3L);
        while (records.size() < numEventsExpected && System.currentTimeMillis() < stop) {
            Thread.sleep(100L);
        }
        replicator.stop();
        HashSet foundNames = new HashSet();
        records.forEach(record -> {
            VerifyRecord.isValid((SourceRecord)record);
            Struct value = (Struct)record.value();
            String after = value.getString("after");
            Document afterDoc = Document.parse((String)after);
            foundNames.add(afterDoc.getString((Object)"name"));
            Envelope.Operation op = Envelope.Operation.forCode((String)value.getString("op"));
            Assertions.assertThat((op == Envelope.Operation.READ || op == Envelope.Operation.CREATE ? 1 : 0) != 0).isTrue();
        });
        Assertions.assertThat((int)records.size()).isEqualTo(2);
        Assertions.assertThat(foundNames).containsOnly(expectedNames);
        this.reuseConfiguration(this.config);
        records = new LinkedList();
        replicator = new Replicator(this.context, this.replicaSet, records::add, x -> {});
        thread = new Thread(() -> ((Replicator)replicator).run());
        thread.start();
        Thread.sleep(2000L);
        replicator.stop();
        records.forEach(record -> VerifyRecord.isValid((SourceRecord)record));
        Assertions.assertThat((boolean)records.isEmpty()).isTrue();
        this.reuseConfiguration(((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS, 1)).build());
        records = new LinkedList();
        replicator = new Replicator(this.context, this.replicaSet, records::add, x -> {});
        thread = new Thread(() -> ((Replicator)replicator).run());
        thread.start();
        Thread.sleep(2000L);
        AtomicReference jonSnowId = new AtomicReference();
        this.primary.execute("removeJonSnow", mongo -> {
            MongoDatabase db = mongo.getDatabase("dbA");
            MongoCollection contacts = db.getCollection("contacts");
            Bson filter = Filters.eq((String)"name", (Object)"Jon Snow");
            FindIterable movieResults = db.getCollection("contacts").find(filter);
            try (MongoCursor cursor = movieResults.iterator();){
                Document doc = (Document)cursor.tryNext();
                Assertions.assertThat((String)doc.getString((Object)"name")).isEqualTo((Object)"Jon Snow");
                Assertions.assertThat((Map)((Map)cursor.tryNext())).isNull();
                jonSnowId.set(doc.getObjectId((Object)"_id"));
                Assertions.assertThat(jonSnowId.get()).isNotNull();
            }
            contacts.deleteOne(Filters.eq((String)"name", (Object)"Jon Snow"));
            Testing.debug((Object)"Removed the Jon Snow document from 'dbA.contacts' collection");
        });
        numEventsExpected = 1;
        stop = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(3L);
        while (records.size() < numEventsExpected && System.currentTimeMillis() < stop) {
            Thread.sleep(100L);
        }
        replicator.stop();
        HashSet foundIds = new HashSet();
        records.forEach(record -> {
            VerifyRecord.isValid((SourceRecord)record);
            Struct key = (Struct)record.key();
            ObjectId id = (ObjectId)JSON.parse((String)key.getString("id"));
            foundIds.add(id);
            if (record.value() != null) {
                Struct value = (Struct)record.value();
                Envelope.Operation op = Envelope.Operation.forCode((String)value.getString("op"));
                Assertions.assertThat((Object)op).isEqualTo((Object)Envelope.Operation.DELETE);
            }
        });
        Assertions.assertThat((int)records.size()).isEqualTo(2);
        this.useConfiguration(this.config);
        records = new LinkedList();
        replicator = new Replicator(this.context, this.replicaSet, records::add, x -> {});
        thread = new Thread(() -> ((Replicator)replicator).run());
        thread.start();
        Thread.sleep(2000L);
        replicator.stop();
        foundNames.clear();
        records.forEach(record -> {
            VerifyRecord.isValid((SourceRecord)record);
            Struct value = (Struct)record.value();
            String after = value.getString("after");
            Document afterDoc = Document.parse((String)after);
            foundNames.add(afterDoc.getString((Object)"name"));
            Envelope.Operation op = Envelope.Operation.forCode((String)value.getString("op"));
            Assertions.assertThat((Object)op).isEqualTo((Object)Envelope.Operation.READ);
        });
        Assertions.assertThat((int)records.size()).isEqualTo(1);
        Object[] allExpectedNames = new Object[]{"Sally Hamm"};
        Assertions.assertThat(foundNames).containsOnly(allExpectedNames);
    }
}

