/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.CursorType;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoIT;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.util.Testing;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ConnectionIT
extends AbstractMongoIT {
    @Before
    public void setUp() {
        TestHelper.cleanDatabase(this.primary, "dbA");
        TestHelper.cleanDatabase(this.primary, "dbB");
        TestHelper.cleanDatabase(this.primary, "dbC");
    }

    @Test
    public void shouldCreateMovieDatabase() {
        this.useConfiguration(((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.DATABASE_WHITELIST, "dbA,dbB")).with(MongoDbConnectorConfig.COLLECTION_BLACKLIST, "dbB.moviesB")).build());
        Testing.print((Object)("Configuration: " + this.config));
        List<String> dbNames = Arrays.asList("A", "B", "C");
        this.primary.execute("shouldCreateMovieDatabases", mongo -> {
            Testing.debug((Object)"Getting or creating 'movies' collections");
            for (String dbName : dbNames) {
                MongoDatabase db = mongo.getDatabase("db" + dbName);
                db.getCollection("movies" + dbName);
            }
            Testing.debug((Object)"Completed getting 'movies' collections");
        });
        this.primary.execute("Add document to movies collections", mongo -> {
            Testing.debug((Object)"Adding document to 'movies' collections");
            for (String dbName : dbNames) {
                MongoCollection collection;
                MongoDatabase db = mongo.getDatabase("db" + dbName);
                MongoCollection movies = collection = db.getCollection("movies" + dbName);
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                movies.insertOne((Object)Document.parse((String)"{ \"name\":\"Starter Wars\"}"), insertOptions);
                Assertions.assertThat((long)collection.count()).isEqualTo(1L);
                Bson filter = Filters.eq((String)"name", (Object)"Starter Wars");
                FindIterable movieResults = collection.find(filter);
                MongoCursor cursor = movieResults.iterator();
                Throwable throwable = null;
                try {
                    Assertions.assertThat((String)((Document)cursor.tryNext()).getString((Object)"name")).isEqualTo((Object)"Starter Wars");
                    Assertions.assertThat((Map)((Map)cursor.tryNext())).isNull();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cursor == null) continue;
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    cursor.close();
                }
            }
            Testing.debug((Object)"Completed adding documents to 'movies' collections");
        });
        Assertions.assertThat((Collection)this.primary.databaseNames()).containsOnly(new Object[]{"dbA", "dbB"});
        Assertions.assertThat((List)this.primary.collections()).containsOnly(new Object[]{new CollectionId(this.replicaSet.replicaSetName(), "dbA", "moviesA")});
        LinkedList eventQueue = new LinkedList();
        int minimumEventsExpected = 1;
        long maxSeconds = 5L;
        this.primary.execute("read oplog from beginning", mongo -> {
            Testing.debug((Object)"Getting local.oplog.rs");
            BsonTimestamp oplogStart = new BsonTimestamp(1, 1);
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.gt((String)"ts", (Object)oplogStart), Filters.exists((String)"fromMigrate", (boolean)false)});
            FindIterable results = mongo.getDatabase("local").getCollection("oplog.rs").find(filter).sort((Bson)new Document("$natural", (Object)1)).oplogReplay(true).noCursorTimeout(true).cursorType(CursorType.TailableAwait);
            Testing.debug((Object)"Reading local.oplog.rs");
            try (MongoCursor cursor = results.iterator();){
                Document event = null;
                long stopTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
                while (System.currentTimeMillis() < stopTime && eventQueue.size() < minimumEventsExpected) {
                    while ((event = (Document)cursor.tryNext()) != null) {
                        eventQueue.add(event);
                    }
                }
                Assertions.assertThat((int)eventQueue.size()).isGreaterThanOrEqualTo(1);
            }
            Testing.debug((Object)"Completed local.oplog.rs");
        });
        eventQueue.forEach(event -> {
            Testing.print((Object)("Found: " + event));
            BsonTimestamp position = (BsonTimestamp)event.get((Object)"ts", BsonTimestamp.class);
            assert (position != null);
        });
    }

    @Test
    public void shouldListDatabases() {
        Testing.Print.enable();
        Testing.print((Object)("Databases: " + this.primary.databaseNames()));
    }
}

