/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoIterableImpl;
import com.mongodb.OperationExecutor;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.ReadOperation;
import com.mongodb.session.ClientSession;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class ListCollectionsIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListCollectionsIterable<TResult> {
    private final String databaseName;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private Bson filter;
    private long maxTimeMS;

    ListCollectionsIterableImpl(ClientSession clientSession, String databaseName, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        super(clientSession, executor, ReadConcern.DEFAULT, readPreference);
        this.databaseName = (String)Assertions.notNull((String)"databaseName", (Object)databaseName);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
    }

    @Override
    public ListCollectionsIterable<TResult> filter(Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        this.filter = filter;
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return new ListCollectionsOperation(this.databaseName, (Decoder)this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocumentOrNull(this.filter, this.codecRegistry)).batchSize(this.getBatchSize() == null ? 0 : this.getBatchSize()).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }
}

