/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.ReplicaSets;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class MongoDbConnectorConfig
extends CommonConnectorConfig {
    public static final Field HOSTS = Field.create((String)"mongodb.hosts").withDisplayName("Hosts").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateHosts}).withDescription("The hostname and port pairs (in the form 'host' or 'host:port') of the MongoDB server(s) in the replica set.");
    public static final Field LOGICAL_NAME = Field.create((String)"mongodb.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Unique name that identifies the MongoDB replica set or cluster and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct MongoDB installation should have a separate namespace and monitored by at most one Debezium connector.");
    public static final Field USER = Field.create((String)"mongodb.user").withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Database user for connecting to MongoDB, if necessary.");
    public static final Field PASSWORD = Field.create((String)"mongodb.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password to be used when connecting to MongoDB, if necessary.");
    public static final Field POLL_INTERVAL_SEC = Field.create((String)"mongodb.poll.interval.sec").withDisplayName("Replica membership poll interval (sec)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Frequency in seconds to look for new, removed, or changed replica sets. Defaults to 30 seconds.");
    public static final Field SSL_ENABLED = Field.create((String)"mongodb.ssl.enabled").withDisplayName("Enable SSL connection to MongoDB").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Should connector use SSL to connect to MongoDB instances");
    public static final Field SSL_ALLOW_INVALID_HOSTNAMES = Field.create((String)"mongodb.ssl.invalid.hostname.allowed").withDisplayName("Allow invalid hostnames for SSL connection").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Whether invalid host names are allowed when using SSL. If true the connection will not prevent man-in-the-middle attacks");
    public static final Field MAX_COPY_THREADS = Field.create((String)"initial.sync.max.threads").withDisplayName("Maximum number of threads for initial sync").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(1).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Maximum number of threads used to perform an intial sync of the collections in a replica set. Defaults to 1.");
    public static final Field CONNECT_BACKOFF_INITIAL_DELAY_MS = Field.create((String)"connect.backoff.initial.delay.ms").withDisplayName("Initial delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(1L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The initial delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 1 second (1000 ms).");
    public static final Field CONNECT_BACKOFF_MAX_DELAY_MS = Field.create((String)"connect.backoff.max.delay.ms").withDisplayName("Maximum delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(120L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The maximum delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 120 second (120,000 ms).");
    public static final Field MAX_FAILED_CONNECTIONS = Field.create((String)"connect.max.attempts").withDisplayName("Connection attempt limit").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(16).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Maximum number of failed connection attempts to a replica set primary before an exception occurs and task is aborted. Defaults to 16, which with the defaults for '" + CONNECT_BACKOFF_INITIAL_DELAY_MS + "' and '" + CONNECT_BACKOFF_MAX_DELAY_MS + "' results in just over 20 minutes of attempts before failing.");
    public static final Field AUTO_DISCOVER_MEMBERS = Field.create((String)"mongodb.members.auto.discover").withDisplayName("Auto-discovery").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Specifies whether the addresses in 'hosts' are seeds that should be used to discover all members of the cluster or replica set ('true'), or whether the address(es) in 'hosts' should be used as is ('false'). The default is 'true'.");
    public static final Field DATABASE_WHITELIST = Field.create((String)"database.whitelist").withDisplayName("DB Whitelist").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateDatabaseBlacklist}).withDescription("The databases for which changes are to be captured");
    public static final Field DATABASE_BLACKLIST = Field.create((String)"database.blacklist").withDisplayName("DB Blacklist").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("The databases for which changes are to be excluded");
    public static final Field COLLECTION_WHITELIST = Field.create((String)"collection.whitelist").withDisplayName("Collections").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateCollectionBlacklist}).withDescription("The collections for which changes are to be captured");
    public static final Field COLLECTION_BLACKLIST = Field.create((String)"collection.blacklist").withValidation(new Field.Validator[]{Field::isListOfRegex}).withInvisibleRecommender();
    protected static final Field TASK_ID = Field.create((String)"mongodb.task.id").withDescription("Internal use only").withValidation(new Field.Validator[]{Field::isInteger}).withInvisibleRecommender();
    public static Field.Set ALL_FIELDS;
    protected static Field.Set EXPOSED_FIELDS;

    public MongoDbConnectorConfig(Configuration config) {
        super(config, config.getString(LOGICAL_NAME));
    }

    protected static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"MongoDB", (Field[])new Field[]{HOSTS, USER, PASSWORD, LOGICAL_NAME, CONNECT_BACKOFF_INITIAL_DELAY_MS, CONNECT_BACKOFF_MAX_DELAY_MS, MAX_FAILED_CONNECTIONS, AUTO_DISCOVER_MEMBERS, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{DATABASE_WHITELIST, DATABASE_BLACKLIST, COLLECTION_WHITELIST, COLLECTION_BLACKLIST, CommonConnectorConfig.TOMBSTONES_ON_DELETE});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{MAX_COPY_THREADS, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.POLL_INTERVAL_MS});
        return config;
    }

    private static int validateHosts(Configuration config, Field field, Field.ValidationOutput problems) {
        String hosts = config.getString(field);
        if (hosts == null) {
            problems.accept(field, (Object)hosts, "Host specification is required");
            return 1;
        }
        int count = 0;
        if (ReplicaSets.parse(hosts) == null) {
            problems.accept(field, (Object)hosts, "Invalid host specification");
            ++count;
        }
        return count;
    }

    private static int validateCollectionBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(COLLECTION_WHITELIST);
        String blacklist = config.getString(COLLECTION_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(COLLECTION_BLACKLIST, (Object)blacklist, "Whitelist is already specified");
            return 1;
        }
        return 0;
    }

    private static int validateDatabaseBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(DATABASE_WHITELIST);
        String blacklist = config.getString(DATABASE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(DATABASE_BLACKLIST, (Object)blacklist, "Whitelist is already specified");
            return 1;
        }
        return 0;
    }

    static {
        EXPOSED_FIELDS = ALL_FIELDS = Field.setOf((Field[])new Field[]{USER, PASSWORD, HOSTS, LOGICAL_NAME, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES, MAX_COPY_THREADS, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.POLL_INTERVAL_MS, MAX_FAILED_CONNECTIONS, CONNECT_BACKOFF_INITIAL_DELAY_MS, CONNECT_BACKOFF_MAX_DELAY_MS, COLLECTION_WHITELIST, COLLECTION_BLACKLIST, AUTO_DISCOVER_MEMBERS, DATABASE_WHITELIST, DATABASE_BLACKLIST, CommonConnectorConfig.TOMBSTONES_ON_DELETE});
    }
}

