/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.Transformation;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnwrapFromMongoDbEnvelope<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnwrapFromMongoDbEnvelope.class);
    private static final Field ARRAY_ENCODING = Field.create((String)"array.encoding").withDisplayName("Array encoding").withEnum(ArrayEncoding.class, (Enum)ArrayEncoding.ARRAY).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The arrays can be encoded using 'array' schema type (the default) ar as a 'struct' (similar to how BSON encodes arrays). 'array' is easier to consume but requires all elements in the array to be of the same type. Use 'struct' if the arrays in data source mix different types together.");
    private static final Field FLATTEN_STRUCT = Field.create((String)"flatten.struct").withDisplayName("Flatten struct").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Flattening structs by concatenating the fields into plain properties, using a (configurable) delimiter.");
    private static final Field DELIMITER = Field.create((String)"flatten.struct.delimiter").withDisplayName("Delimiter for flattened struct").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_").withDescription("Delimiter to concat between field names from the input record when generating field names for theoutput record.");
    private final ExtractField<R> afterExtractor = new ExtractField.Value();
    private final ExtractField<R> patchExtractor = new ExtractField.Value();
    private final ExtractField<R> keyExtractor = new ExtractField.Key();
    private MongoDataConverter converter;
    private final Flatten<R> recordFlattener = new Flatten.Value();
    private boolean flattenStruct;
    private String delimiter;

    public R apply(R r) {
        String newValueSchemaName = r.valueSchema().name();
        if (newValueSchemaName.endsWith(".Envelope")) {
            newValueSchemaName = newValueSchemaName.substring(0, newValueSchemaName.length() - 9);
        }
        SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct().name(newValueSchemaName);
        SchemaBuilder keySchemabuilder = SchemaBuilder.struct();
        BsonDocument valueDocument = null;
        ConnectRecord afterRecord = this.afterExtractor.apply(r);
        ConnectRecord key = this.keyExtractor.apply(r);
        BsonDocument keyDocument = BsonDocument.parse((String)("{ \"id\" : " + key.key().toString() + "}"));
        if (afterRecord.value() == null) {
            ConnectRecord patchRecord = this.patchExtractor.apply(r);
            if (patchRecord.value() != null) {
                valueDocument = BsonDocument.parse((String)patchRecord.value().toString());
                if (!(valueDocument = valueDocument.getDocument((Object)"$set")).containsKey((Object)"id")) {
                    valueDocument.append("id", keyDocument.get((Object)"id"));
                }
                if (this.flattenStruct) {
                    BsonDocument newDocument = new BsonDocument();
                    valueDocument.forEach((fKey, fValue) -> newDocument.put(fKey.replace(".", this.delimiter), fValue));
                    valueDocument = newDocument;
                }
            } else {
                valueDocument = new BsonDocument();
            }
        } else {
            valueDocument = BsonDocument.parse((String)afterRecord.value().toString());
            valueDocument.remove((Object)"_id");
            valueDocument.append("id", keyDocument.get((Object)"id"));
        }
        Set valuePairs = valueDocument.entrySet();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry valuePairsforSchema : valuePairs) {
            if (((String)valuePairsforSchema.getKey()).toString().equalsIgnoreCase("$set")) {
                BsonDocument val1 = BsonDocument.parse((String)((BsonValue)valuePairsforSchema.getValue()).toString());
                Set keyValuesforSetSchema = val1.entrySet();
                for (Map.Entry keyValuesforSetSchemaEntry : keyValuesforSetSchema) {
                    this.converter.addFieldSchema(keyValuesforSetSchemaEntry, valueSchemaBuilder);
                }
                continue;
            }
            this.converter.addFieldSchema(valuePairsforSchema, valueSchemaBuilder);
        }
        for (Map.Entry keyPairsforSchema : keyPairs) {
            this.converter.addFieldSchema(keyPairsforSchema, keySchemabuilder);
        }
        Schema finalValueSchema = valueSchemaBuilder.build();
        Struct finalValueStruct = new Struct(finalValueSchema);
        Schema finalKeySchema = keySchemabuilder.build();
        Struct finalKeyStruct = new Struct(finalKeySchema);
        for (Map.Entry valuePairsforStruct : valuePairs) {
            if (((String)valuePairsforStruct.getKey()).toString().equalsIgnoreCase("$set")) {
                BsonDocument val1 = BsonDocument.parse((String)((BsonValue)valuePairsforStruct.getValue()).toString());
                Set keyvalueforSetStruct = val1.entrySet();
                for (Map.Entry keyvalueforSetStructEntry : keyvalueforSetStruct) {
                    this.converter.convertRecord(keyvalueforSetStructEntry, finalValueSchema, finalValueStruct);
                }
                continue;
            }
            this.converter.convertRecord(valuePairsforStruct, finalValueSchema, finalValueStruct);
        }
        for (Map.Entry keyPairsforStruct : keyPairs) {
            this.converter.convertRecord(keyPairsforStruct, finalKeySchema, finalKeyStruct);
        }
        if (this.flattenStruct) {
            ConnectRecord flattenRecord = this.recordFlattener.apply(r.newRecord(r.topic(), r.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, finalValueSchema, (Object)finalValueStruct, r.timestamp()));
            return (R)flattenRecord;
        }
        if (finalValueSchema.fields().isEmpty()) {
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, null, null, r.timestamp());
        }
        return (R)r.newRecord(r.topic(), r.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, finalValueSchema, (Object)finalValueStruct, r.timestamp());
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, null, (Field[])new Field[]{ARRAY_ENCODING});
        return config;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
        Configuration config = Configuration.from(map);
        Field.Set configFields = Field.setOf((Field[])new Field[]{ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER});
        if (!config.validateAndRecord((Iterable)configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.converter = new MongoDataConverter(ArrayEncoding.parse(config.getString(ARRAY_ENCODING)));
        this.flattenStruct = config.getBoolean(FLATTEN_STRUCT);
        this.delimiter = config.getString(DELIMITER);
        HashMap<String, String> afterExtractorConfig = new HashMap<String, String>();
        afterExtractorConfig.put("field", "after");
        HashMap<String, String> patchExtractorConfig = new HashMap<String, String>();
        patchExtractorConfig.put("field", "patch");
        HashMap<String, String> keyExtractorConfig = new HashMap<String, String>();
        keyExtractorConfig.put("field", "id");
        this.afterExtractor.configure(afterExtractorConfig);
        this.patchExtractor.configure(patchExtractorConfig);
        this.keyExtractor.configure(keyExtractorConfig);
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("delimiter", this.delimiter);
        this.recordFlattener.configure(delegateConfig);
    }

    public static enum ArrayEncoding implements EnumeratedValue
    {
        ARRAY("array"),
        DOCUMENT("document");

        private final String value;

        private ArrayEncoding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ArrayEncoding parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ArrayEncoding option : ArrayEncoding.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static ArrayEncoding parse(String value, String defaultValue) {
            ArrayEncoding mode = ArrayEncoding.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ArrayEncoding.parse(defaultValue);
            }
            return mode;
        }
    }
}

