/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.TopicSelector;

public class MongoDbTaskContext
extends CdcSourceTaskContext {
    private final Filters filters;
    private final SourceInfo source;
    private final TopicSelector topicSelector;
    private final boolean emitTombstoneOnDelete;
    private final String serverName;
    private final ConnectionContext connectionContext;

    public MongoDbTaskContext(Configuration config) {
        super("MongoDB", config.getString(MongoDbConnectorConfig.LOGICAL_NAME));
        String serverName = config.getString(MongoDbConnectorConfig.LOGICAL_NAME);
        this.filters = new Filters(config);
        this.source = new SourceInfo(serverName);
        this.topicSelector = TopicSelector.defaultSelector(serverName);
        this.emitTombstoneOnDelete = config.getBoolean(CommonConnectorConfig.TOMBSTONES_ON_DELETE);
        this.serverName = config.getString(MongoDbConnectorConfig.LOGICAL_NAME);
        this.connectionContext = new ConnectionContext(config);
    }

    public TopicSelector topicSelector() {
        return this.topicSelector;
    }

    public Filters filters() {
        return this.filters;
    }

    public SourceInfo source() {
        return this.source;
    }

    public boolean isEmitTombstoneOnDelete() {
        return this.emitTombstoneOnDelete;
    }

    public String serverName() {
        return this.serverName;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

