/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoMappingCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import java.util.Collection;
import java.util.Iterator;

class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = iterable;
        this.mapper = mapper;
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }

    @Override
    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Override
    public V first() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return (V)iterator.next();
    }

    @Override
    public void forEach(final Block<? super V> block) {
        this.iterable.forEach(new Block<U>(){

            public void apply(U document) {
                block.apply(MappingIterable.this.mapper.apply(document));
            }
        });
    }

    @Override
    public <A extends Collection<? super V>> A into(final A target) {
        this.forEach((Block<? super V>)new Block<V>(){

            public void apply(V v) {
                target.add(v);
            }
        });
        return target;
    }

    public MappingIterable<U, V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> newMap) {
        return new MappingIterable<V, W>(this, newMap);
    }
}

