/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class Time {
    public static final String SCHEMA_NAME = "io.debezium.time.Time";

    public static SchemaBuilder builder() {
        return SchemaBuilder.int32().name(SCHEMA_NAME).version(Integer.valueOf(1));
    }

    public static Schema schema() {
        return Time.builder().build();
    }

    public static int toMilliOfDay(Object value, TemporalAdjuster adjuster) {
        LocalTime time = Conversions.toLocalTime(value);
        if (adjuster != null) {
            time = time.with(adjuster);
        }
        long micros = Math.floorDiv(time.toNanoOfDay(), Conversions.NANOSECONDS_PER_MILLISECOND);
        assert (Math.abs(micros) < Integer.MAX_VALUE);
        return (int)micros;
    }

    private Time() {
    }
}

