/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregateIterableImpl;
import com.mongodb.ChangeStreamIterableImpl;
import com.mongodb.DistinctIterableImpl;
import com.mongodb.FindIterableImpl;
import com.mongodb.ListIndexesIterableImpl;
import com.mongodb.MapReduceIterableImpl;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.OperationExecutor;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexesOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.RenameCollectionOperation;
import com.mongodb.session.ClientSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<TDocument> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, ReadConcern readConcern, OperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.retryWrites = retryWrites;
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<NewTDocument>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, readConcern, this.executor);
    }

    @Override
    public long count() {
        return this.count((Bson)new BsonDocument(), new CountOptions());
    }

    @Override
    public long count(Bson filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    public long count(Bson filter, CountOptions options) {
        return this.executeCount(null, filter, options);
    }

    @Override
    public long count(ClientSession clientSession) {
        return this.count(clientSession, (Bson)new BsonDocument());
    }

    @Override
    public long count(ClientSession clientSession, Bson filter) {
        return this.count(clientSession, filter, new CountOptions());
    }

    @Override
    public long count(ClientSession clientSession, Bson filter, CountOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeCount(clientSession, filter, options);
    }

    private long executeCount(ClientSession clientSession, Bson filter, CountOptions options) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.toBsonDocument(filter)).skip((long)options.getSkip()).limit((long)options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options.getCollation()).readConcern(this.readConcern);
        if (options.getHint() != null) {
            operation.hint((BsonValue)this.toBsonDocument(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint((BsonValue)new BsonString(options.getHintString()));
        }
        return (Long)this.executor.execute(operation, this.readPreference, clientSession);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return this.createDistinctIterable(null, fieldName, filter, resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createDistinctIterable(clientSession, fieldName, filter, resultClass);
    }

    private <TResult> DistinctIterable<TResult> createDistinctIterable(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, fieldName, filter);
    }

    @Override
    public FindIterable<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Class<TResult> resultClass) {
        return this.find((Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindIterable<TDocument> find(Bson filter) {
        return this.find(filter, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Bson filter, Class<TResult> resultClass) {
        return this.createFindIterable(null, filter, resultClass);
    }

    @Override
    public FindIterable<TDocument> find(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.find(clientSession, (Bson)new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.find(clientSession, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindIterable<TDocument> find(ClientSession clientSession, Bson filter) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.find(clientSession, filter, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createFindIterable(clientSession, filter, resultClass);
    }

    private <TResult> FindIterable<TResult> createFindIterable(ClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        return new FindIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, filter, new FindOptions());
    }

    @Override
    public AggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(null, pipeline, resultClass);
    }

    @Override
    public AggregateIterable<TDocument> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createAggregateIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> AggregateIterable<TResult> createAggregateIterable(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregateIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, this.namespace, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline, resultClass);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return this.createMapReduceIterable(null, mapFunction, reduceFunction, resultClass);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createMapReduceIterable(clientSession, mapFunction, reduceFunction, resultClass);
    }

    private <TResult> MapReduceIterable<TResult> createMapReduceIterable(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReduceIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.executeBulkWrite(null, requests, options);
    }

    @Override
    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(clientSession, requests, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeBulkWrite(clientSession, requests, options);
    }

    private BulkWriteResult executeBulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        Assertions.notNull((String)"requests", requests);
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<TDocument> writeModel : requests) {
            InsertRequest writeRequest;
            if (writeModel == null) {
                throw new IllegalArgumentException("requests can not contain a null value");
            }
            if (writeModel instanceof InsertOneModel) {
                Object document = ((InsertOneModel)writeModel).getDocument();
                if (this.getCodec() instanceof CollectibleCodec) {
                    document = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
                }
                writeRequest = new InsertRequest(this.documentToBsonDocument(document));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(replaceOneModel.getFilter()), this.documentToBsonDocument(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert()).collation(replaceOneModel.getOptions().getCollation());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateOneModel.getFilter()), this.toBsonDocument(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert()).collation(updateOneModel.getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(updateOneModel.getOptions().getArrayFilters()));
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.toBsonDocument(updateManyModel.getFilter()), this.toBsonDocument(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert()).collation(updateManyModel.getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(updateManyModel.getOptions().getArrayFilters()));
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteOneModel.getFilter())).multi(false).collation(deleteOneModel.getOptions().getCollation());
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.toBsonDocument(deleteManyModel.getFilter())).multi(true).collation(deleteManyModel.getOptions().getCollation());
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add(writeRequest);
        }
        return (BulkWriteResult)this.executor.execute(new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(options.getBypassDocumentValidation()), clientSession);
    }

    @Override
    public void insertOne(TDocument document) {
        this.insertOne(document, new InsertOneOptions());
    }

    @Override
    public void insertOne(TDocument document, InsertOneOptions options) {
        Assertions.notNull((String)"document", document);
        this.executeInsertOne(null, document, options);
    }

    @Override
    public void insertOne(ClientSession clientSession, TDocument document) {
        this.insertOne(clientSession, document, new InsertOneOptions());
    }

    @Override
    public void insertOne(ClientSession clientSession, TDocument document, InsertOneOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        Assertions.notNull((String)"document", document);
        this.executeInsertOne(clientSession, document, options);
    }

    private void executeInsertOne(ClientSession clientSession, TDocument document, InsertOneOptions options) {
        Object insertDocument = document;
        if (this.getCodec() instanceof CollectibleCodec) {
            insertDocument = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
        }
        this.executeSingleWriteRequest(clientSession, (WriteRequest)new InsertRequest(this.documentToBsonDocument(insertDocument)), options.getBypassDocumentValidation());
    }

    @Override
    public void insertMany(List<? extends TDocument> documents) {
        this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        this.executeInsertMany(null, documents, options);
    }

    @Override
    public void insertMany(ClientSession clientSession, List<? extends TDocument> documents) {
        this.insertMany(clientSession, documents, new InsertManyOptions());
    }

    @Override
    public void insertMany(ClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeInsertMany(clientSession, documents, options);
    }

    private void executeInsertMany(ClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options) {
        Assertions.notNull((String)"documents", documents);
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (Object document : documents) {
            if (document == null) {
                throw new IllegalArgumentException("documents can not contain a null value");
            }
            if (this.getCodec() instanceof CollectibleCodec) {
                document = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.documentToBsonDocument(document)));
        }
        this.executor.execute(new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(options.getBypassDocumentValidation()), clientSession);
    }

    @Override
    public DeleteResult deleteOne(Bson filter) {
        return this.deleteOne(filter, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteOne(Bson filter, DeleteOptions options) {
        return this.executeDelete(null, filter, options, false);
    }

    @Override
    public DeleteResult deleteOne(ClientSession clientSession, Bson filter) {
        return this.deleteOne(clientSession, filter, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteOne(ClientSession clientSession, Bson filter, DeleteOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeDelete(clientSession, filter, options, false);
    }

    @Override
    public DeleteResult deleteMany(Bson filter) {
        return this.deleteMany(filter, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteMany(Bson filter, DeleteOptions options) {
        return this.executeDelete(null, filter, options, true);
    }

    @Override
    public DeleteResult deleteMany(ClientSession clientSession, Bson filter) {
        return this.deleteMany(clientSession, filter, new DeleteOptions());
    }

    @Override
    public DeleteResult deleteMany(ClientSession clientSession, Bson filter, DeleteOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeDelete(clientSession, filter, options, true);
    }

    @Override
    public UpdateResult replaceOne(Bson filter, TDocument replacement) {
        return this.replaceOne(filter, replacement, new UpdateOptions());
    }

    @Override
    public UpdateResult replaceOne(Bson filter, TDocument replacement, UpdateOptions updateOptions) {
        return this.executeReplaceOne(null, filter, replacement, updateOptions);
    }

    @Override
    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.replaceOne(clientSession, filter, replacement, new UpdateOptions());
    }

    @Override
    public UpdateResult replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, UpdateOptions updateOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeReplaceOne(clientSession, filter, replacement, updateOptions);
    }

    private UpdateResult executeReplaceOne(ClientSession clientSession, Bson filter, TDocument replacement, UpdateOptions updateOptions) {
        return this.toUpdateResult(this.executeSingleWriteRequest(clientSession, (WriteRequest)new UpdateRequest(this.toBsonDocument(filter), this.documentToBsonDocument(replacement), WriteRequest.Type.REPLACE).upsert(updateOptions.isUpsert()).collation(updateOptions.getCollation()), updateOptions.getBypassDocumentValidation()));
    }

    @Override
    public UpdateResult updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.executeUpdate(null, filter, update, updateOptions, false);
    }

    @Override
    public UpdateResult updateOne(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeUpdate(clientSession, filter, update, updateOptions, false);
    }

    @Override
    public UpdateResult updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.executeUpdate(null, filter, update, updateOptions, true);
    }

    @Override
    public UpdateResult updateMany(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeUpdate(clientSession, filter, update, updateOptions, true);
    }

    @Override
    public TDocument findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public TDocument findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.executeFindOneAndDelete(null, filter, options);
    }

    @Override
    public TDocument findOneAndDelete(ClientSession clientSession, Bson filter) {
        return this.findOneAndDelete(clientSession, filter, new FindOneAndDeleteOptions());
    }

    @Override
    public TDocument findOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeFindOneAndDelete(clientSession, filter, options);
    }

    private TDocument executeFindOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return (TDocument)this.executor.execute(new FindAndDeleteOperation(this.namespace, this.writeConcern, this.retryWrites, this.getCodec()).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).collation(options.getCollation()), clientSession);
    }

    @Override
    public TDocument findOneAndReplace(Bson filter, TDocument replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public TDocument findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.executeFindOneAndReplace(null, filter, replacement, options);
    }

    @Override
    public TDocument findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.findOneAndReplace(clientSession, filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public TDocument findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeFindOneAndReplace(clientSession, filter, replacement, options);
    }

    private TDocument executeFindOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return (TDocument)this.executor.execute(new FindAndReplaceOperation(this.namespace, this.writeConcern, this.retryWrites, this.getCodec(), this.documentToBsonDocument(replacement)).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).returnOriginal(options.getReturnDocument() == ReturnDocument.BEFORE).upsert(options.isUpsert()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options.getBypassDocumentValidation()).collation(options.getCollation()), clientSession);
    }

    @Override
    public TDocument findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public TDocument findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.executeFindOneAndUpdate(null, filter, update, options);
    }

    @Override
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public TDocument findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeFindOneAndUpdate(clientSession, filter, update, options);
    }

    private TDocument executeFindOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return (TDocument)this.executor.execute(new FindAndUpdateOperation(this.namespace, this.writeConcern, this.retryWrites, this.getCodec(), this.toBsonDocument(update)).filter(this.toBsonDocument(filter)).projection(this.toBsonDocument(options.getProjection())).sort(this.toBsonDocument(options.getSort())).returnOriginal(options.getReturnDocument() == ReturnDocument.BEFORE).upsert(options.isUpsert()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).bypassDocumentValidation(options.getBypassDocumentValidation()).collation(options.getCollation()).arrayFilters(this.toBsonDocumentList(options.getArrayFilters())), clientSession);
    }

    @Override
    public void drop() {
        this.executeDrop(null);
    }

    @Override
    public void drop(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDrop(clientSession);
    }

    private void executeDrop(ClientSession clientSession) {
        this.executor.execute(new DropCollectionOperation(this.namespace, this.writeConcern), clientSession);
    }

    @Override
    public String createIndex(Bson keys) {
        return this.createIndex(keys, new IndexOptions());
    }

    @Override
    public String createIndex(Bson keys, IndexOptions indexOptions) {
        return this.createIndexes(Collections.singletonList(new IndexModel(keys, indexOptions))).get(0);
    }

    @Override
    public String createIndex(ClientSession clientSession, Bson keys) {
        return this.createIndex(clientSession, keys, new IndexOptions());
    }

    @Override
    public String createIndex(ClientSession clientSession, Bson keys, IndexOptions indexOptions) {
        return this.createIndexes(clientSession, Collections.singletonList(new IndexModel(keys, indexOptions))).get(0);
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes) {
        return this.createIndexes(indexes, new CreateIndexOptions());
    }

    @Override
    public List<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        return this.executeCreateIndexes(null, indexes, createIndexOptions);
    }

    @Override
    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.createIndexes(clientSession, indexes, new CreateIndexOptions());
    }

    @Override
    public List<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.executeCreateIndexes(clientSession, indexes, createIndexOptions);
    }

    private List<String> executeCreateIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions) {
        Assertions.notNull((String)"indexes", indexes);
        Assertions.notNull((String)"createIndexOptions", (Object)createIndexOptions);
        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>(indexes.size());
        for (IndexModel model : indexes) {
            if (model == null) {
                throw new IllegalArgumentException("indexes can not contain a null value");
            }
            indexRequests.add(new IndexRequest(this.toBsonDocument(model.getKeys())).name(model.getOptions().getName()).background(model.getOptions().isBackground()).unique(model.getOptions().isUnique()).sparse(model.getOptions().isSparse()).expireAfter(model.getOptions().getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(model.getOptions().getVersion()).weights(this.toBsonDocument(model.getOptions().getWeights())).defaultLanguage(model.getOptions().getDefaultLanguage()).languageOverride(model.getOptions().getLanguageOverride()).textVersion(model.getOptions().getTextVersion()).sphereVersion(model.getOptions().getSphereVersion()).bits(model.getOptions().getBits()).min(model.getOptions().getMin()).max(model.getOptions().getMax()).bucketSize(model.getOptions().getBucketSize()).storageEngine(this.toBsonDocument(model.getOptions().getStorageEngine())).partialFilterExpression(this.toBsonDocument(model.getOptions().getPartialFilterExpression())).collation(model.getOptions().getCollation()));
        }
        CreateIndexesOperation createIndexesOperation = new CreateIndexesOperation(this.getNamespace(), indexRequests, this.writeConcern).maxTime(createIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        this.executor.execute(createIndexesOperation, clientSession);
        return createIndexesOperation.getIndexNames();
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> resultClass) {
        return this.createListIndexesIterable(null, resultClass);
    }

    @Override
    public ListIndexesIterable<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListIndexesIterable(clientSession, resultClass);
    }

    private <TResult> ListIndexesIterable<TResult> createListIndexesIterable(ClientSession clientSession, Class<TResult> resultClass) {
        return new ListIndexesIterableImpl<TResult>(clientSession, this.getNamespace(), resultClass, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public void dropIndex(String indexName) {
        this.dropIndex(indexName, new DropIndexOptions());
    }

    @Override
    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        this.executeDropIndex(null, indexName, dropIndexOptions);
    }

    @Override
    public void dropIndex(Bson keys) {
        this.dropIndex(keys, new DropIndexOptions());
    }

    @Override
    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions) {
        this.executeDropIndex(null, keys, dropIndexOptions);
    }

    @Override
    public void dropIndex(ClientSession clientSession, String indexName) {
        this.dropIndex(clientSession, indexName, new DropIndexOptions());
    }

    @Override
    public void dropIndex(ClientSession clientSession, Bson keys) {
        this.dropIndex(clientSession, keys, new DropIndexOptions());
    }

    @Override
    public void dropIndex(ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDropIndex(clientSession, indexName, dropIndexOptions);
    }

    @Override
    public void dropIndex(ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDropIndex(clientSession, keys, dropIndexOptions);
    }

    @Override
    public void dropIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void dropIndexes(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDropIndex(clientSession, "*", new DropIndexOptions());
    }

    @Override
    public void dropIndexes(DropIndexOptions dropIndexOptions) {
        this.dropIndex("*", dropIndexOptions);
    }

    @Override
    public void dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions) {
        this.dropIndex(clientSession, "*", dropIndexOptions);
    }

    private void executeDropIndex(ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions) {
        Assertions.notNull((String)"dropIndexOptions", (Object)dropIndexOptions);
        this.executor.execute(new DropIndexOperation(this.namespace, indexName, this.writeConcern).maxTime(dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), clientSession);
    }

    private void executeDropIndex(ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions) {
        this.executor.execute(new DropIndexOperation(this.namespace, keys.toBsonDocument(BsonDocument.class, this.codecRegistry), this.writeConcern).maxTime(dropIndexOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), clientSession);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.executeRenameCollection(null, newCollectionNamespace, renameCollectionOptions);
    }

    @Override
    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeRenameCollection(clientSession, newCollectionNamespace, renameCollectionOptions);
    }

    private void executeRenameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.executor.execute(new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace, this.writeConcern).dropTarget(renameCollectionOptions.isDropTarget()), clientSession);
    }

    private DeleteResult executeDelete(ClientSession clientSession, Bson filter, DeleteOptions deleteOptions, boolean multi) {
        BulkWriteResult result = this.executeSingleWriteRequest(clientSession, (WriteRequest)new DeleteRequest(this.toBsonDocument(filter)).multi(multi).collation(deleteOptions.getCollation()), null);
        if (result.wasAcknowledged()) {
            return DeleteResult.acknowledged((long)result.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    }

    private UpdateResult executeUpdate(ClientSession clientSession, Bson filter, Bson update, UpdateOptions updateOptions, boolean multi) {
        return this.toUpdateResult(this.executeSingleWriteRequest(clientSession, (WriteRequest)new UpdateRequest(this.toBsonDocument(filter), this.toBsonDocument(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi).collation(updateOptions.getCollation()).arrayFilters(this.toBsonDocumentList(updateOptions.getArrayFilters())), updateOptions.getBypassDocumentValidation()));
    }

    private BulkWriteResult executeSingleWriteRequest(ClientSession clientSession, WriteRequest request, Boolean bypassDocumentValidation) {
        try {
            return (BulkWriteResult)this.executor.execute(new MixedBulkWriteOperation(this.namespace, Arrays.asList(request), true, this.writeConcern, this.retryWrites).bypassDocumentValidation(bypassDocumentValidation), clientSession);
        }
        catch (MongoBulkWriteException e) {
            if (e.getWriteErrors().isEmpty()) {
                throw new MongoWriteConcernException(e.getWriteConcernError(), this.translateBulkWriteResult(request, e.getWriteResult()), e.getServerAddress());
            }
            throw new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress());
        }
    }

    private WriteConcernResult translateBulkWriteResult(WriteRequest request, BulkWriteResult writeResult) {
        switch (request.getType()) {
            case INSERT: {
                return WriteConcernResult.acknowledged((int)writeResult.getInsertedCount(), (boolean)false, null);
            }
            case DELETE: {
                return WriteConcernResult.acknowledged((int)writeResult.getDeletedCount(), (boolean)false, null);
            }
            case UPDATE: 
            case REPLACE: {
                return WriteConcernResult.acknowledged((int)(writeResult.getMatchedCount() + writeResult.getUpserts().size()), (writeResult.getMatchedCount() > 0 ? 1 : 0) != 0, writeResult.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)writeResult.getUpserts().get(0)).getId());
            }
        }
        throw new MongoInternalException("Unhandled write request type: " + request.getType());
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)modifiedCount, (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<TDocument> getCodec() {
        return this.codecRegistry.get(this.documentClass);
    }

    private BsonDocument documentToBsonDocument(TDocument document) {
        return BsonDocumentWrapper.asBsonDocument(document, (CodecRegistry)this.codecRegistry);
    }

    private BsonDocument toBsonDocument(Bson bson) {
        return bson == null ? null : bson.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    private List<BsonDocument> toBsonDocumentList(List<? extends Bson> bsonList) {
        if (bsonList == null) {
            return null;
        }
        ArrayList<BsonDocument> bsonDocumentList = new ArrayList<BsonDocument>(bsonList.size());
        for (Bson bson : bsonList) {
            bsonDocumentList.add(this.toBsonDocument(bson));
        }
        return bsonDocumentList;
    }
}

