/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeEventCreator;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher<T extends DataCollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
    private final TopicSelector topicSelector;
    private final DatabaseSchema schema;
    private final ChangeEventQueue<Object> queue;
    private final DataCollectionFilters.DataCollectionFilter<T> filter;

    public EventDispatcher(TopicSelector topicSelector, DatabaseSchema schema, ChangeEventQueue<Object> queue, DataCollectionFilters.DataCollectionFilter<T> filter) {
        this.topicSelector = topicSelector;
        this.schema = schema;
        this.queue = queue;
        this.filter = filter;
    }

    public void dispatchDataChangeEvent(T dataCollectionId, Supplier<ChangeRecordEmitter> changeRecordEmitter, ChangeEventCreator changeEventCreator) throws InterruptedException {
        if (!this.filter.isIncluded(dataCollectionId)) {
            LOGGER.trace("Skipping data change event for {}", dataCollectionId);
            return;
        }
        DataCollectionSchema dataCollectionSchema = this.schema.getDataCollectionSchema((DataCollectionId)dataCollectionId);
        if (dataCollectionSchema == null) {
            throw new IllegalArgumentException("No metadata registered for captured table " + dataCollectionId);
        }
        changeRecordEmitter.get().emitChangeRecords(dataCollectionSchema, new ChangeRecordReceiver((DataCollectionId)dataCollectionId, changeEventCreator, dataCollectionSchema));
    }

    public void dispatchSchemaChangeEvent(T dataCollectionId, Supplier<SchemaChangeEventEmitter> schemaChangeEventEmitter) throws InterruptedException {
        if (!this.filter.isIncluded(dataCollectionId)) {
            LOGGER.trace("Skipping data change event for {}", dataCollectionId);
            return;
        }
        schemaChangeEventEmitter.get().emitSchemaChangeEvent(new SchemaChangeEventReceiver());
    }

    private final class SchemaChangeEventReceiver
    implements SchemaChangeEventEmitter.Receiver {
        private SchemaChangeEventReceiver() {
        }

        @Override
        public void schemaChangeEvent(SchemaChangeEvent event) throws InterruptedException {
            EventDispatcher.this.schema.applySchemaChange(event);
        }
    }

    private final class ChangeRecordReceiver
    implements ChangeRecordEmitter.Receiver {
        private final DataCollectionId dataCollectionId;
        private final ChangeEventCreator changeEventCreator;
        private final DataCollectionSchema dataCollectionSchema;

        private ChangeRecordReceiver(DataCollectionId dataCollectionId, ChangeEventCreator changeEventCreator, DataCollectionSchema dataCollectionSchema) {
            this.dataCollectionId = dataCollectionId;
            this.changeEventCreator = changeEventCreator;
            this.dataCollectionSchema = dataCollectionSchema;
        }

        @Override
        public void changeRecord(Envelope.Operation operation, Object key, Struct value, OffsetContext offsetContext) throws InterruptedException {
            Objects.requireNonNull(key, "key must not be null");
            Objects.requireNonNull(value, "key must not be null");
            LOGGER.trace("Received change record for {} operation on key {}", (Object)operation, key);
            Schema keySchema = this.dataCollectionSchema.keySchema();
            String topicName = EventDispatcher.this.topicSelector.topicNameFor(this.dataCollectionId);
            SourceRecord record = new SourceRecord(offsetContext.getPartition(), offsetContext.getOffset(), topicName, null, keySchema, key, this.dataCollectionSchema.getEnvelopeSchema().schema(), (Object)value);
            EventDispatcher.this.queue.enqueue(this.changeEventCreator.createDataChangeEvent(record));
            boolean emitTombstonesOnDelete = true;
            if (emitTombstonesOnDelete && operation == Envelope.Operation.DELETE) {
                SourceRecord tombStone = record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), null, null, record.timestamp());
                EventDispatcher.this.queue.enqueue(this.changeEventCreator.createDataChangeEvent(tombStone));
            }
        }
    }
}

