/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCredential;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.Authenticator;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.NativeAuthenticator;
import com.mongodb.connection.ScramSha1Authenticator;
import com.mongodb.connection.ServerVersion;

class DefaultAuthenticator
extends Authenticator {
    DefaultAuthenticator(MongoCredential credential) {
        super(credential);
        Assertions.isTrueArgument("unspecified authentication mechanism", credential.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        this.createAuthenticator(connectionDescription).authenticate(connection, connectionDescription);
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        this.createAuthenticator(connectionDescription).authenticateAsync(connection, connectionDescription, callback);
    }

    Authenticator createAuthenticator(ConnectionDescription connectionDescription) {
        if (connectionDescription.getServerVersion().compareTo(new ServerVersion(2, 7)) >= 0) {
            return new ScramSha1Authenticator(this.getCredential());
        }
        return new NativeAuthenticator(this.getCredential());
    }
}

