/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import com.mongodb.operation.WriteConcernHelper;
import java.util.Arrays;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

final class UserOperationHelper {
    static BsonDocument asCommandDocument(MongoCredential credential, boolean readOnly, String commandName) {
        BsonDocument document = new BsonDocument();
        document.put(commandName, (BsonValue)new BsonString(credential.getUserName()));
        document.put("pwd", (BsonValue)new BsonString(NativeAuthenticationHelper.createAuthenticationHash(credential.getUserName(), credential.getPassword())));
        document.put("digestPassword", (BsonValue)BsonBoolean.FALSE);
        document.put("roles", (BsonValue)new BsonArray(Arrays.asList(new BsonString(UserOperationHelper.getRoleName(credential, readOnly)))));
        return document;
    }

    private static String getRoleName(MongoCredential credential, boolean readOnly) {
        return credential.getSource().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    static BsonDocument asCollectionQueryDocument(MongoCredential credential) {
        return new BsonDocument("user", (BsonValue)new BsonString(credential.getUserName()));
    }

    static BsonDocument asCollectionUpdateDocument(MongoCredential credential, boolean readOnly) {
        return UserOperationHelper.asCollectionQueryDocument(credential).append("pwd", (BsonValue)new BsonString(NativeAuthenticationHelper.createAuthenticationHash(credential.getUserName(), credential.getPassword()))).append("readOnly", (BsonValue)BsonBoolean.valueOf((boolean)readOnly));
    }

    static BsonDocument asCollectionInsertDocument(MongoCredential credential, boolean readOnly) {
        return UserOperationHelper.asCollectionUpdateDocument(credential, readOnly).append("_id", (BsonValue)new BsonObjectId(new ObjectId()));
    }

    static void translateUserCommandException(MongoCommandException e) {
        if (e.getErrorCode() == 100 && WriteConcernHelper.hasWriteConcernError(e.getResponse())) {
            throw WriteConcernHelper.createWriteConcernError(e.getResponse(), e.getServerAddress());
        }
        throw e;
    }

    static SingleResultCallback<Void> userCommandCallback(final SingleResultCallback<Void> wrappedCallback) {
        return new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    if (t instanceof MongoCommandException && WriteConcernHelper.hasWriteConcernError(((MongoCommandException)t).getResponse())) {
                        wrappedCallback.onResult(null, WriteConcernHelper.createWriteConcernError(((MongoCommandException)t).getResponse(), ((MongoCommandException)t).getServerAddress()));
                    } else {
                        wrappedCallback.onResult(null, t);
                    }
                } else {
                    wrappedCallback.onResult(null, null);
                }
            }
        };
    }

    private UserOperationHelper() {
    }
}

