/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.SourceInfo;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SourceInfoTest {
    private static String REPLICA_SET_NAME = "myReplicaSet";
    private SourceInfo source;
    private Map<String, String> partition;

    @Before
    public void beforeEach() {
        this.source = new SourceInfo("serverX");
    }

    @Test
    public void shouldHaveSchemaForSource() {
        Schema schema = this.source.schema();
        Assertions.assertThat((String)schema.name()).isNotEmpty();
        Assertions.assertThat((Integer)schema.version()).isNotNull();
        Assertions.assertThat((Object)schema.field("name").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("rs").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("ns").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("sec").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)schema.field("ord").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)schema.field("h").schema()).isEqualTo((Object)Schema.OPTIONAL_INT64_SCHEMA);
        Assertions.assertThat((Object)schema.field("initsync").schema()).isEqualTo((Object)Schema.OPTIONAL_BOOLEAN_SCHEMA);
    }

    @Test
    public void shouldProducePartitionMap() {
        this.partition = this.source.partition(REPLICA_SET_NAME);
        Assertions.assertThat((String)this.partition.get("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)this.partition.get("server_id")).isEqualTo((Object)"serverX");
        Assertions.assertThat((int)this.partition.size()).isEqualTo(2);
    }

    @Test
    public void shouldReturnSamePartitionMapForSameReplicaName() {
        this.partition = this.source.partition(REPLICA_SET_NAME);
        Assertions.assertThat(this.partition).isSameAs((Object)this.source.partition(REPLICA_SET_NAME));
    }

    @Test
    public void shouldSetAndReturnRecordedOffset() {
        Document event = new Document().append("ts", (Object)new BsonTimestamp(100, 2)).append("h", (Object)1987654321L).append("ns", (Object)"dbA.collectA");
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
        this.source.offsetStructForEvent(REPLICA_SET_NAME, event);
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(true);
        Map offset = this.source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)100);
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)2);
        Assertions.assertThat(offset.get("h")).isEqualTo((Object)1987654321L);
        Map partition = this.source.partition(REPLICA_SET_NAME);
        this.source = new SourceInfo("serverX");
        this.source.setOffsetFor(partition, offset);
        offset = this.source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)100);
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)2);
        Assertions.assertThat(offset.get("h")).isEqualTo((Object)1987654321L);
        BsonTimestamp ts = this.source.lastOffsetTimestamp(REPLICA_SET_NAME);
        Assertions.assertThat((int)ts.getTime()).isEqualTo(100);
        Assertions.assertThat((int)ts.getInc()).isEqualTo(2);
        Struct struct = this.source.lastOffsetStruct(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "dbA", "collectA"));
        Assertions.assertThat((Integer)struct.getInt32("sec")).isEqualTo(100);
        Assertions.assertThat((Integer)struct.getInt32("ord")).isEqualTo(2);
        Assertions.assertThat((Long)struct.getInt64("h")).isEqualTo(1987654321L);
        Assertions.assertThat((String)struct.getString("ns")).isEqualTo((Object)"dbA.collectA");
        Assertions.assertThat((String)struct.getString("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)struct.getString("name")).isEqualTo((Object)"serverX");
        Assertions.assertThat((Boolean)struct.getBoolean("initsync")).isNull();
    }

    @Test
    public void shouldReturnOffsetForUnusedReplicaName() {
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
        Map offset = this.source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)0);
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)0);
        Assertions.assertThat(offset.get("h")).isNull();
        BsonTimestamp ts = this.source.lastOffsetTimestamp(REPLICA_SET_NAME);
        Assertions.assertThat((int)ts.getTime()).isEqualTo(0);
        Assertions.assertThat((int)ts.getInc()).isEqualTo(0);
        Struct struct = this.source.lastOffsetStruct(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "dbA", "collectA"));
        Assertions.assertThat((Integer)struct.getInt32("sec")).isEqualTo(0);
        Assertions.assertThat((Integer)struct.getInt32("ord")).isEqualTo(0);
        Assertions.assertThat((Long)struct.getInt64("h")).isNull();
        Assertions.assertThat((String)struct.getString("ns")).isEqualTo((Object)"dbA.collectA");
        Assertions.assertThat((String)struct.getString("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)struct.getString("name")).isEqualTo((Object)"serverX");
        Assertions.assertThat((Boolean)struct.getBoolean("initsync")).isNull();
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
    }

    @Test
    public void shouldReturnRecordedOffsetForUsedReplicaName() {
        Document event = new Document().append("ts", (Object)new BsonTimestamp(100, 2)).append("h", (Object)1987654321L).append("ns", (Object)"dbA.collectA");
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
        this.source.offsetStructForEvent(REPLICA_SET_NAME, event);
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(true);
        Map offset = this.source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)100);
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)2);
        Assertions.assertThat(offset.get("h")).isEqualTo((Object)1987654321L);
        BsonTimestamp ts = this.source.lastOffsetTimestamp(REPLICA_SET_NAME);
        Assertions.assertThat((int)ts.getTime()).isEqualTo(100);
        Assertions.assertThat((int)ts.getInc()).isEqualTo(2);
        Struct struct = this.source.lastOffsetStruct(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "dbA", "collectA"));
        Assertions.assertThat((Integer)struct.getInt32("sec")).isEqualTo(100);
        Assertions.assertThat((Integer)struct.getInt32("ord")).isEqualTo(2);
        Assertions.assertThat((Long)struct.getInt64("h")).isEqualTo(1987654321L);
        Assertions.assertThat((String)struct.getString("ns")).isEqualTo((Object)"dbA.collectA");
        Assertions.assertThat((String)struct.getString("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)struct.getString("name")).isEqualTo((Object)"serverX");
        Assertions.assertThat((Boolean)struct.getBoolean("initsync")).isNull();
    }

    @Test
    public void shouldReturnOffsetForUnusedReplicaNameDuringInitialSync() {
        this.source.startInitialSync(REPLICA_SET_NAME);
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
        Map offset = this.source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)0);
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)0);
        Assertions.assertThat(offset.get("h")).isNull();
        BsonTimestamp ts = this.source.lastOffsetTimestamp(REPLICA_SET_NAME);
        Assertions.assertThat((int)ts.getTime()).isEqualTo(0);
        Assertions.assertThat((int)ts.getInc()).isEqualTo(0);
        Struct struct = this.source.lastOffsetStruct(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "dbA", "collectA"));
        Assertions.assertThat((Integer)struct.getInt32("sec")).isEqualTo(0);
        Assertions.assertThat((Integer)struct.getInt32("ord")).isEqualTo(0);
        Assertions.assertThat((Long)struct.getInt64("h")).isNull();
        Assertions.assertThat((String)struct.getString("ns")).isEqualTo((Object)"dbA.collectA");
        Assertions.assertThat((String)struct.getString("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)struct.getString("name")).isEqualTo((Object)"serverX");
        Assertions.assertThat((Boolean)struct.getBoolean("initsync")).isEqualTo(true);
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
    }

    @Test
    public void shouldReturnRecordedOffsetForUsedReplicaNameDuringInitialSync() {
        this.source.startInitialSync(REPLICA_SET_NAME);
        Document event = new Document().append("ts", (Object)new BsonTimestamp(100, 2)).append("h", (Object)1987654321L).append("ns", (Object)"dbA.collectA");
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
        this.source.offsetStructForEvent(REPLICA_SET_NAME, event);
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(true);
        Map offset = this.source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)100);
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)2);
        Assertions.assertThat(offset.get("h")).isEqualTo((Object)1987654321L);
        BsonTimestamp ts = this.source.lastOffsetTimestamp(REPLICA_SET_NAME);
        Assertions.assertThat((int)ts.getTime()).isEqualTo(100);
        Assertions.assertThat((int)ts.getInc()).isEqualTo(2);
        Struct struct = this.source.lastOffsetStruct(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "dbA", "collectA"));
        Assertions.assertThat((Integer)struct.getInt32("sec")).isEqualTo(100);
        Assertions.assertThat((Integer)struct.getInt32("ord")).isEqualTo(2);
        Assertions.assertThat((Long)struct.getInt64("h")).isEqualTo(1987654321L);
        Assertions.assertThat((String)struct.getString("ns")).isEqualTo((Object)"dbA.collectA");
        Assertions.assertThat((String)struct.getString("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)struct.getString("name")).isEqualTo((Object)"serverX");
        Assertions.assertThat((Boolean)struct.getBoolean("initsync")).isEqualTo(true);
    }

    @Test
    public void versionIsPresent() {
        Assertions.assertThat((String)this.source.offsetStructForEvent("rs", null).getString("version")).isEqualTo((Object)Module.version());
    }
}

