/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import java.util.regex.Pattern;

@Immutable
public final class CollectionId {
    private static final Pattern IDENTIFIER_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private final String replicaSetName;
    private final String dbName;
    private final String name;

    public static CollectionId parse(String str) {
        String[] parts = IDENTIFIER_SEPARATOR_PATTERN.split(str);
        if (parts.length < 3) {
            return null;
        }
        return new CollectionId(parts[0], parts[1], parts[2]);
    }

    public CollectionId(String replicaSetName, String dbName, String collectionName) {
        this.replicaSetName = replicaSetName;
        this.dbName = dbName;
        this.name = collectionName;
        assert (this.replicaSetName != null);
        assert (this.dbName != null);
        assert (this.name != null);
    }

    public String name() {
        return this.name;
    }

    public String dbName() {
        return this.dbName;
    }

    public String replicaSetName() {
        return this.replicaSetName;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CollectionId) {
            CollectionId that = (CollectionId)obj;
            return this.replicaSetName.equals(that.replicaSetName) && this.dbName.equals(that.dbName) && this.name.equals(that.name);
        }
        return false;
    }

    public String namespace() {
        return this.dbName + "." + this.name;
    }

    public String toString() {
        return this.replicaSetName + "." + this.dbName + "." + this.name;
    }
}

