/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Transformation;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class UnwrapFromMongoDbEnvelope<R extends ConnectRecord<R>>
implements Transformation<R> {
    private final ExtractField<R> afterExtractor = new ExtractField.Value();
    private final ExtractField<R> patchExtractor = new ExtractField.Value();
    private final ExtractField<R> keyExtractor = new ExtractField.Key();

    public R apply(R r) {
        SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct();
        SchemaBuilder keySchemabuilder = SchemaBuilder.struct();
        BsonDocument valueDocument = null;
        ConnectRecord afterRecord = this.afterExtractor.apply(r);
        ConnectRecord key = this.keyExtractor.apply(r);
        BsonDocument keyDocument = BsonDocument.parse((String)("{ \"id\" : " + key.key().toString() + "}"));
        if (afterRecord.value() == null) {
            ConnectRecord patchRecord = this.patchExtractor.apply(r);
            if (patchRecord.value() != null) {
                valueDocument = BsonDocument.parse((String)patchRecord.value().toString());
                if (!(valueDocument = valueDocument.getDocument((Object)"$set")).containsKey((Object)"id")) {
                    valueDocument.append("id", keyDocument.get((Object)"id"));
                }
            } else {
                valueDocument = new BsonDocument();
            }
        } else {
            valueDocument = BsonDocument.parse((String)afterRecord.value().toString());
            valueDocument.remove((Object)"_id");
            valueDocument.append("id", keyDocument.get((Object)"id"));
        }
        Set valuePairs = valueDocument.entrySet();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry valuePairsforSchema : valuePairs) {
            if (((String)valuePairsforSchema.getKey()).toString().equalsIgnoreCase("$set")) {
                BsonDocument val1 = BsonDocument.parse((String)((BsonValue)valuePairsforSchema.getValue()).toString());
                Set keyValuesforSetSchema = val1.entrySet();
                for (Map.Entry keyValuesforSetSchemaEntry : keyValuesforSetSchema) {
                    MongoDataConverter.addFieldSchema(keyValuesforSetSchemaEntry, valueSchemaBuilder);
                }
                continue;
            }
            MongoDataConverter.addFieldSchema(valuePairsforSchema, valueSchemaBuilder);
        }
        for (Map.Entry keyPairsforSchema : keyPairs) {
            MongoDataConverter.addFieldSchema(keyPairsforSchema, keySchemabuilder);
        }
        Schema finalValueSchema = valueSchemaBuilder.build();
        Struct finalValueStruct = new Struct(finalValueSchema);
        Schema finalKeySchema = keySchemabuilder.build();
        Struct finalKeyStruct = new Struct(finalKeySchema);
        for (Map.Entry valuePairsforStruct : valuePairs) {
            if (((String)valuePairsforStruct.getKey()).toString().equalsIgnoreCase("$set")) {
                BsonDocument val1 = BsonDocument.parse((String)((BsonValue)valuePairsforStruct.getValue()).toString());
                Set keyvalueforSetStruct = val1.entrySet();
                for (Map.Entry keyvalueforSetStructEntry : keyvalueforSetStruct) {
                    MongoDataConverter.convertRecord(keyvalueforSetStructEntry, finalValueSchema, finalValueStruct);
                }
                continue;
            }
            MongoDataConverter.convertRecord(valuePairsforStruct, finalValueSchema, finalValueStruct);
        }
        for (Map.Entry keyPairsforStruct : keyPairs) {
            MongoDataConverter.convertRecord(keyPairsforStruct, finalKeySchema, finalKeyStruct);
        }
        if (finalValueSchema.fields().isEmpty()) {
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, null, null, r.timestamp());
        }
        return (R)r.newRecord(r.topic(), r.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, finalValueSchema, (Object)finalValueStruct, r.timestamp());
    }

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
        HashMap<String, String> afterExtractorConfig = new HashMap<String, String>();
        afterExtractorConfig.put("field", "after");
        HashMap<String, String> patchExtractorConfig = new HashMap<String, String>();
        patchExtractorConfig.put("field", "patch");
        HashMap<String, String> keyExtractorConfig = new HashMap<String, String>();
        keyExtractorConfig.put("field", "id");
        this.afterExtractor.configure(afterExtractorConfig);
        this.patchExtractor.configure(patchExtractorConfig);
        this.keyExtractor.configure(keyExtractorConfig);
    }
}

