/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoClients;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MongoClientsIT {
    private static List<ServerAddress> addresses;
    private MongoClients clients;

    @BeforeClass
    public static void beforeAll() {
        Configuration config = Configuration.fromSystemProperties((String)"connector.");
        String host = config.getString(MongoDbConnectorConfig.HOSTS);
        addresses = MongoUtil.parseAddresses((String)host);
    }

    @Before
    public void beforeEach() {
        this.clients = MongoClients.create().build();
    }

    @After
    public void afterEach() {
        if (this.clients != null) {
            try {
                this.clients.clear();
            }
            finally {
                this.clients = null;
            }
        }
    }

    @Test
    public void shouldReturnSameInstanceForSameAddress() {
        addresses.forEach(address -> {
            MongoClient client1 = this.clients.clientFor(address);
            MongoClient client2 = this.clients.clientFor(address);
            Assertions.assertThat((Object)client1).isSameAs((Object)client2);
            MongoClient client3 = this.clients.clientFor(address.toString());
            MongoClient client4 = this.clients.clientFor(address);
            Assertions.assertThat((Object)client3).isSameAs((Object)client4);
            Assertions.assertThat((Object)client3).isSameAs((Object)client1);
            MongoClient client5 = this.clients.clientFor(address.toString());
            MongoClient client6 = this.clients.clientFor(address.toString());
            Assertions.assertThat((Object)client5).isSameAs((Object)client6);
            Assertions.assertThat((Object)client5).isSameAs((Object)client1);
        });
    }

    @Test
    public void shouldReturnSameInstanceForSameAddresses() {
        MongoClient client1 = this.clients.clientForMembers(addresses);
        MongoClient client2 = this.clients.clientForMembers(addresses);
        Assertions.assertThat((Object)client1).isSameAs((Object)client2);
        ServerAddress[] array = addresses.toArray(new ServerAddress[addresses.size()]);
        MongoClient client3 = this.clients.clientForMembers(array);
        MongoClient client4 = this.clients.clientForMembers(array);
        Assertions.assertThat((Object)client3).isSameAs((Object)client4);
        Assertions.assertThat((Object)client3).isSameAs((Object)client1);
        String addressesStr = MongoUtil.toString(addresses);
        MongoClient client5 = this.clients.clientForMembers(addressesStr);
        MongoClient client6 = this.clients.clientForMembers(addressesStr);
        Assertions.assertThat((Object)client5).isSameAs((Object)client6);
        Assertions.assertThat((Object)client5).isSameAs((Object)client1);
    }
}

