/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicationContext;
import io.debezium.util.Testing;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoIT
implements Testing {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMongoIT.class);
    protected Configuration config;
    protected ReplicationContext context;
    protected ReplicaSet replicaSet;
    protected ConnectionContext.MongoPrimary primary;

    @Before
    public void beforeEach() {
        Testing.Print.disable();
        Testing.Debug.disable();
        this.useConfiguration(Configuration.fromSystemProperties((String)"connector."));
    }

    protected void useConfiguration(Configuration config) {
        this.config = config;
        this.initialize(true);
    }

    protected void reuseConfiguration(Configuration config) {
        this.config = config;
        this.initialize(false);
    }

    private void initialize(boolean restartFromBeginning) {
        Map partition = null;
        Map offsetForPartition = null;
        if (!restartFromBeginning && this.context != null && this.replicaSet != null && this.context.source().hasOffset(this.replicaSet.replicaSetName())) {
            partition = this.context.source().partition(this.replicaSet.replicaSetName());
            offsetForPartition = this.context.source().lastOffset(this.replicaSet.replicaSetName());
        }
        this.context = new ReplicationContext(this.config);
        Assertions.assertThat((String)this.context.hosts()).isNotEmpty();
        this.replicaSet = ReplicaSet.parse((String)this.context.hosts());
        this.context.configureLoggingContext(this.replicaSet.replicaSetName());
        if (partition != null) {
            this.context.source().setOffsetFor(partition, offsetForPartition);
        }
        this.primary = this.context.primaryFor(this.replicaSet, this.connectionErrorHandler(3));
    }

    @After
    public void afterEach() {
        if (this.context != null) {
            this.context.shutdown();
        }
    }

    protected BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }
}

