/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.debezium.annotation.ThreadSafe;
import io.debezium.document.Array;
import io.debezium.document.ArrayReader;
import io.debezium.document.BasicArray;
import io.debezium.document.BasicDocument;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

@ThreadSafe
final class JacksonReader
implements DocumentReader,
ArrayReader {
    public static final JacksonReader INSTANCE = new JacksonReader();
    private static final JsonFactory factory = new JsonFactory();

    private JacksonReader() {
    }

    @Override
    public Document read(InputStream jsonStream) throws IOException {
        return this.parse(factory.createParser(jsonStream));
    }

    @Override
    public Document read(Reader jsonReader) throws IOException {
        return this.parse(factory.createParser(jsonReader));
    }

    @Override
    public Document read(String json) throws IOException {
        return this.parse(factory.createParser(json));
    }

    @Override
    public Document read(File jsonFile) throws IOException {
        return this.parse(factory.createParser(jsonFile));
    }

    @Override
    public Document read(URL jsonUrl) throws IOException {
        return this.parse(factory.createParser(jsonUrl));
    }

    @Override
    public Document read(byte[] rawBytes) throws IOException {
        return this.parse(factory.createParser(rawBytes));
    }

    @Override
    public Array readArray(InputStream jsonStream) throws IOException {
        return this.parseArray(factory.createParser(jsonStream), false);
    }

    @Override
    public Array readArray(Reader jsonReader) throws IOException {
        return this.parseArray(factory.createParser(jsonReader), false);
    }

    @Override
    public Array readArray(URL jsonUrl) throws IOException {
        return this.parseArray(factory.createParser(jsonUrl), false);
    }

    @Override
    public Array readArray(File jsonFile) throws IOException {
        return this.parseArray(factory.createParser(jsonFile), false);
    }

    @Override
    public Array readArray(String jsonArray) throws IOException {
        return this.parseArray(factory.createParser(jsonArray), false);
    }

    private Document parse(JsonParser parser) throws IOException {
        try {
            Document document = this.parseDocument(parser, false);
            return document;
        }
        finally {
            parser.close();
        }
    }

    private Document parseDocument(JsonParser parser, boolean nested) throws IOException {
        BasicDocument doc = new BasicDocument();
        JsonToken token = null;
        if (!nested) {
            token = parser.nextToken();
            if (!nested && token != JsonToken.START_OBJECT) {
                throw new IOException("Expected data to start with an Object, but was " + token);
            }
        }
        String fieldName = null;
        token = parser.nextToken();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    fieldName = parser.getCurrentName();
                    break;
                }
                case START_OBJECT: {
                    doc.setDocument(fieldName, this.parseDocument(parser, true));
                    break;
                }
                case START_ARRAY: {
                    doc.setArray((CharSequence)fieldName, this.parseArray(parser, true));
                    break;
                }
                case VALUE_STRING: {
                    doc.setString(fieldName, parser.getValueAsString());
                    break;
                }
                case VALUE_TRUE: {
                    doc.setBoolean(fieldName, true);
                    break;
                }
                case VALUE_FALSE: {
                    doc.setBoolean(fieldName, false);
                    break;
                }
                case VALUE_NULL: {
                    doc.setNull(fieldName);
                    break;
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    switch (parser.getNumberType()) {
                        case FLOAT: {
                            doc.setNumber((CharSequence)fieldName, parser.getFloatValue());
                            break;
                        }
                        case DOUBLE: {
                            doc.setNumber((CharSequence)fieldName, parser.getDoubleValue());
                            break;
                        }
                        case BIG_DECIMAL: {
                            doc.setNumber((CharSequence)fieldName, parser.getDecimalValue());
                            break;
                        }
                        case INT: {
                            doc.setNumber((CharSequence)fieldName, parser.getIntValue());
                            break;
                        }
                        case LONG: {
                            doc.setNumber((CharSequence)fieldName, parser.getLongValue());
                            break;
                        }
                        case BIG_INTEGER: {
                            doc.setNumber((CharSequence)fieldName, parser.getBigIntegerValue());
                        }
                    }
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    break;
                }
                case NOT_AVAILABLE: {
                    throw new JsonParseException(parser, "Non-blocking parsers are not supported", parser.getCurrentLocation());
                }
                case END_ARRAY: {
                    throw new JsonParseException(parser, "Not expecting an END_ARRAY token", parser.getCurrentLocation());
                }
                case END_OBJECT: {
                    throw new JsonParseException(parser, "Not expecting an END_OBJECT token", parser.getCurrentLocation());
                }
            }
            token = parser.nextToken();
        }
        return doc;
    }

    private Array parseArray(JsonParser parser, boolean nested) throws IOException {
        BasicArray array = new BasicArray();
        JsonToken token = null;
        if (!nested) {
            token = parser.nextToken();
            if (!nested && token != JsonToken.START_ARRAY) {
                throw new IOException("Expected data to start with an Array, but was " + token);
            }
        }
        token = parser.nextToken();
        while (token != JsonToken.END_ARRAY) {
            switch (token) {
                case START_OBJECT: {
                    array.add(this.parseDocument(parser, true));
                    break;
                }
                case START_ARRAY: {
                    array.add(this.parseArray(parser, true));
                    break;
                }
                case VALUE_STRING: {
                    array.add(parser.getValueAsString());
                    break;
                }
                case VALUE_TRUE: {
                    array.add(true);
                    break;
                }
                case VALUE_FALSE: {
                    array.add(false);
                    break;
                }
                case VALUE_NULL: {
                    array.addNull();
                    break;
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    switch (parser.getNumberType()) {
                        case FLOAT: {
                            array.add(parser.getFloatValue());
                            break;
                        }
                        case DOUBLE: {
                            array.add(parser.getDoubleValue());
                            break;
                        }
                        case BIG_DECIMAL: {
                            array.add(parser.getDecimalValue());
                            break;
                        }
                        case INT: {
                            array.add(parser.getIntValue());
                            break;
                        }
                        case LONG: {
                            array.add(parser.getLongValue());
                            break;
                        }
                        case BIG_INTEGER: {
                            array.add(parser.getBigIntegerValue());
                        }
                    }
                    break;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    break;
                }
                case NOT_AVAILABLE: {
                    throw new JsonParseException(parser, "Non-blocking parsers are not supported", parser.getCurrentLocation());
                }
                case FIELD_NAME: {
                    throw new JsonParseException(parser, "Not expecting a FIELD_NAME token", parser.getCurrentLocation());
                }
                case END_ARRAY: {
                    throw new JsonParseException(parser, "Not expecting an END_ARRAY token", parser.getCurrentLocation());
                }
                case END_OBJECT: {
                    throw new JsonParseException(parser, "Not expecting an END_OBJECT token", parser.getCurrentLocation());
                }
            }
            token = parser.nextToken();
        }
        return array;
    }

    static {
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
    }
}

