/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.Configuration;
import io.debezium.function.Predicates;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.text.ParsingException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseHistory
implements DatabaseHistory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Configuration config;
    private HistoryRecordComparator comparator = HistoryRecordComparator.INSTANCE;
    private boolean skipUnparseableDDL;
    private Predicate<String> ddlFilter = x -> false;

    protected AbstractDatabaseHistory() {
    }

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator) {
        this.config = config;
        this.comparator = comparator != null ? comparator : HistoryRecordComparator.INSTANCE;
        this.skipUnparseableDDL = config.getBoolean(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS);
        String ddlFilter = config.getString(DatabaseHistory.DDL_FILTER);
        this.ddlFilter = ddlFilter != null ? Predicates.includes(ddlFilter) : this.ddlFilter;
    }

    @Override
    public void start() {
    }

    @Override
    public final void record(Map<String, ?> source, Map<String, ?> position, String databaseName, Tables schema, String ddl) throws DatabaseHistoryException {
        this.storeRecord(new HistoryRecord(source, position, databaseName, ddl));
    }

    @Override
    public final void recover(Map<String, ?> source, Map<String, ?> position, Tables schema, DdlParser ddlParser) {
        this.logger.debug("Recovering DDL history for source partition {} and offset {}", source, position);
        HistoryRecord stopPoint = new HistoryRecord(source, position, null, null);
        this.recoverRecords(recovered -> {
            if (this.comparator.isAtOrBefore((HistoryRecord)recovered, stopPoint)) {
                String ddl = recovered.ddl();
                if (ddl != null) {
                    ddlParser.setCurrentSchema(recovered.databaseName());
                    if (this.ddlFilter.test(ddl)) {
                        this.logger.info("a DDL '{}' was filtered out of processing", (Object)ddl);
                        return;
                    }
                    try {
                        this.logger.debug("Applying: {}", (Object)ddl);
                        ddlParser.parse(ddl, schema);
                    }
                    catch (ParsingException e) {
                        if (this.skipUnparseableDDL) {
                            this.logger.warn("Ignoring unparseable statements '{}' stored in database history: {}", (Object)ddl, (Object)e);
                        }
                        this.logger.error("Cannot parse DDL statements {} stored in history, exiting", (Object)ddl);
                        throw e;
                    }
                }
            } else {
                this.logger.debug("Skipping: {}", (Object)recovered.ddl());
            }
        });
    }

    protected abstract void storeRecord(HistoryRecord var1) throws DatabaseHistoryException;

    protected abstract void recoverRecords(Consumer<HistoryRecord> var1);

    @Override
    public void stop() {
    }
}

