/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufBsonDocument;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.ResponseCallback;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.CommandListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;

class CommandProtocol<T>
implements Protocol<T> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private static final Set<String> SECURITY_SENSITIVE_COMMANDS = new HashSet<String>(Arrays.asList("authenticate", "saslStart", "saslContinue", "getnonce", "createUser", "updateUser", "copydbgetnonce", "copydbsaslstart", "copydb"));
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final Decoder<T> commandResultDecoder;
    private final FieldNameValidator fieldNameValidator;
    private boolean slaveOk;
    private CommandListener commandListener;
    private volatile String commandName;

    public CommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(database, "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.fieldNameValidator = Assertions.notNull("fieldNameValidator", fieldNameValidator);
    }

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public CommandProtocol<T> slaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
        return this;
    }

    @Override
    public T execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        long startTimeNanos = System.nanoTime();
        CommandMessage commandMessage = new CommandMessage(this.namespace.getFullName(), this.command, this.slaveOk, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
        ResponseBuffers responseBuffers = null;
        try {
            this.sendMessage(commandMessage, connection);
            responseBuffers = connection.receiveMessage(commandMessage.getId());
            if (!ProtocolHelper.isCommandOk((BsonReader)new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer())))) {
                throw ProtocolHelper.getCommandFailureException((BsonDocument)CommandProtocol.getResponseDocument(responseBuffers, commandMessage, new BsonDocumentCodec()), connection.getDescription().getServerAddress());
            }
            T retval = CommandProtocol.getResponseDocument(responseBuffers, commandMessage, this.commandResultDecoder);
            if (this.commandListener != null) {
                this.sendSucceededEvent(connection.getDescription(), startTimeNanos, commandMessage, (BsonDocument)CommandProtocol.getResponseDocument(responseBuffers, commandMessage, new RawBsonDocumentCodec()));
            }
            LOGGER.debug("Command execution completed");
            T t = retval;
            return t;
        }
        catch (RuntimeException e) {
            this.sendFailedEvent(connection.getDescription(), startTimeNanos, commandMessage, e);
            throw e;
        }
        finally {
            if (responseBuffers != null) {
                responseBuffers.close();
            }
        }
    }

    private static <D> D getResponseDocument(ResponseBuffers responseBuffers, CommandMessage commandMessage, Decoder<D> decoder) {
        responseBuffers.reset();
        ReplyMessage<D> replyMessage = new ReplyMessage<D>(responseBuffers, decoder, commandMessage.getId());
        return replyMessage.getDocuments().get(0);
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<T> callback) {
        long startTimeNanos = System.nanoTime();
        CommandMessage message = new CommandMessage(this.namespace.getFullName(), this.command, this.slaveOk, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
        boolean sentStartedEvent = false;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            int documentPosition = ProtocolHelper.encodeMessageWithMetadata(message, (BsonOutput)bsonOutput).getFirstDocumentPosition();
            this.sendStartedEvent(connection, bsonOutput, message, documentPosition);
            sentStartedEvent = true;
            CommandResultCallback receiveCallback = new CommandResultCallback(callback, message, connection.getDescription(), startTimeNanos);
            connection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SendMessageCallback<T>(connection, bsonOutput, message, this.getCommandName(), startTimeNanos, this.commandListener, callback, receiveCallback));
        }
        catch (Throwable t) {
            if (sentStartedEvent) {
                this.sendFailedEvent(connection.getDescription(), startTimeNanos, message, t);
            }
            callback.onResult(null, t);
        }
    }

    @Override
    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    private String getCommandName() {
        return this.commandName != null ? this.commandName : (String)this.command.keySet().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(CommandMessage message, InternalConnection connection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            int documentPosition = message.encodeWithMetadata((BsonOutput)bsonOutput).getFirstDocumentPosition();
            this.sendStartedEvent(connection, bsonOutput, message, documentPosition);
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
        }
        finally {
            bsonOutput.close();
        }
    }

    private void sendStartedEvent(InternalConnection connection, ByteBufferBsonOutput bsonOutput, CommandMessage message, int documentPosition) {
        if (this.commandListener != null) {
            ByteBufBsonDocument commandDocument;
            ByteBufBsonDocument byteBufBsonDocument = ByteBufBsonDocument.createOne(bsonOutput, documentPosition);
            if (byteBufBsonDocument.containsKey("$query")) {
                commandDocument = byteBufBsonDocument.getDocument("$query");
                this.commandName = (String)commandDocument.keySet().iterator().next();
            } else {
                commandDocument = byteBufBsonDocument;
                this.commandName = byteBufBsonDocument.getFirstKey();
            }
            ByteBufBsonDocument commandDocumentForEvent = SECURITY_SENSITIVE_COMMANDS.contains(this.commandName) ? new BsonDocument() : commandDocument;
            ProtocolHelper.sendCommandStartedEvent(message, this.namespace.getDatabaseName(), this.commandName, commandDocumentForEvent, connection.getDescription(), this.commandListener);
        }
    }

    private void sendSucceededEvent(ConnectionDescription connectionDescription, long startTimeNanos, CommandMessage commandMessage, BsonDocument response) {
        if (this.commandListener != null) {
            BsonDocument responseDocumentForEvent = SECURITY_SENSITIVE_COMMANDS.contains(this.getCommandName()) ? new BsonDocument() : response;
            ProtocolHelper.sendCommandSucceededEvent(commandMessage, this.getCommandName(), responseDocumentForEvent, connectionDescription, startTimeNanos, this.commandListener);
        }
    }

    private void sendFailedEvent(ConnectionDescription connectionDescription, long startTimeNanos, CommandMessage commandMessage, Throwable t) {
        if (this.commandListener != null) {
            Throwable commandEventException = t;
            if (t instanceof MongoCommandException && SECURITY_SENSITIVE_COMMANDS.contains(this.getCommandName())) {
                commandEventException = new MongoCommandException(new BsonDocument(), connectionDescription.getServerAddress());
            }
            ProtocolHelper.sendCommandFailedEvent(commandMessage, this.getCommandName(), connectionDescription, startTimeNanos, commandEventException, this.commandListener);
        }
    }

    class CommandResultCallback
    extends ResponseCallback {
        private final SingleResultCallback<T> callback;
        private final CommandMessage message;
        private final ConnectionDescription connectionDescription;
        private final long startTimeNanos;

        CommandResultCallback(SingleResultCallback<T> callback, CommandMessage message, ConnectionDescription connectionDescription, long startTimeNanos) {
            super(message.getId(), connectionDescription.getServerAddress());
            this.callback = callback;
            this.message = message;
            this.connectionDescription = connectionDescription;
            this.startTimeNanos = startTimeNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void callCallback(ResponseBuffers responseBuffers, Throwable throwableFromCallback) {
            try {
                if (throwableFromCallback != null) {
                    throw throwableFromCallback;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Command execution completed");
                }
                if (!ProtocolHelper.isCommandOk((BsonReader)new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer())))) {
                    throw ProtocolHelper.getCommandFailureException((BsonDocument)CommandProtocol.getResponseDocument(responseBuffers, this.message, (Decoder)new BsonDocumentCodec()), this.connectionDescription.getServerAddress());
                }
                if (CommandProtocol.this.commandListener != null) {
                    CommandProtocol.this.sendSucceededEvent(this.connectionDescription, this.startTimeNanos, this.message, (BsonDocument)CommandProtocol.getResponseDocument(responseBuffers, this.message, (Decoder)new RawBsonDocumentCodec()));
                }
                this.callback.onResult(CommandProtocol.getResponseDocument(responseBuffers, this.message, CommandProtocol.this.commandResultDecoder), null);
            }
            catch (Throwable t) {
                CommandProtocol.this.sendFailedEvent(this.connectionDescription, this.startTimeNanos, this.message, t);
                this.callback.onResult(null, t);
            }
            finally {
                if (responseBuffers != null) {
                    responseBuffers.close();
                }
            }
        }
    }
}

