/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.ddl.DdlTokenizer;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.text.Position;
import io.debezium.text.TokenStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DdlParser {
    private final Set<String> keywords = new HashSet<String>();
    private final Set<String> statementStarts = new HashSet<String>();
    private final String terminator;
    private String currentSchema = null;
    protected final boolean skipViews;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final DataTypeParser dataTypeParser = new DataTypeParser();
    protected Tables databaseTables;
    protected TokenStream tokens;
    private final List<DdlParserListener> listeners = new CopyOnWriteArrayList<DdlParserListener>();

    public DdlParser(String terminator) {
        this(terminator, false);
    }

    public DdlParser(String terminator, boolean includeViews) {
        this.terminator = terminator != null ? terminator : ";";
        this.skipViews = !includeViews;
        this.initializeDataTypes(this.dataTypeParser);
        this.initializeKeywords(this.keywords::add);
        this.initializeStatementStarts(this.statementStarts::add);
    }

    public void addListener(DdlParserListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(DdlParserListener listener) {
        return listener != null ? this.listeners.remove(listener) : false;
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    protected void initializeDataTypes(DataTypeParser dataTypeParser) {
    }

    protected void initializeKeywords(TokenSet keywords) {
    }

    protected void initializeStatementStarts(TokenSet statementStartTokens) {
        statementStartTokens.add("CREATE", "ALTER", "DROP", "INSERT", "SET", "GRANT", "REVOKE");
    }

    public final String terminator() {
        return this.terminator;
    }

    protected boolean isNextTokenQuotedIdentifier() {
        return this.tokens.matchesAnyOf(8, 16);
    }

    protected int determineTokenType(int type, String token) {
        if (this.statementStarts.contains(token)) {
            type |= 0x80;
        }
        if (this.keywords.contains(token)) {
            type |= 0x40;
        }
        if (this.terminator.equals(token)) {
            type |= 0x100;
        }
        return type;
    }

    public void setCurrentSchema(String name) {
        this.currentSchema = name;
    }

    public String currentSchema() {
        return this.currentSchema;
    }

    protected String parseSchemaQualifiedName(TokenStream.Marker start) {
        String first = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String second = this.tokens.consume();
            return first + "." + second;
        }
        if (this.currentSchema() != null) {
            return this.currentSchema() + "." + first;
        }
        return first;
    }

    protected TableId parseQualifiedTableName(TokenStream.Marker start) {
        String name = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String tableName = this.tokens.consume();
            return this.resolveTableId(name, tableName);
        }
        return this.resolveTableId(this.currentSchema(), name);
    }

    protected List<TableId> parseQualifiedTableNames(TokenStream.Marker start) {
        LinkedList<TableId> ids = new LinkedList<TableId>();
        TableId id = this.parseQualifiedTableName(start);
        if (id != null) {
            ids.add(id);
        }
        while (this.tokens.canConsume(',')) {
            id = this.parseQualifiedTableName(start);
            if (id == null) continue;
            ids.add(id);
        }
        return ids;
    }

    protected TableId resolveTableId(String schemaName, String tableName) {
        return new TableId(schemaName, null, tableName);
    }

    protected boolean skipComments() {
        return true;
    }

    public final void parse(String ddlContent, Tables databaseTables) {
        TokenStream stream = new TokenStream(ddlContent, new DdlTokenizer(!this.skipComments(), this::determineTokenType), false);
        stream.start();
        this.parse(stream, databaseTables);
    }

    public final void parse(TokenStream ddlContent, Tables databaseTables) throws ParsingException, IllegalStateException {
        this.tokens = ddlContent;
        this.databaseTables = databaseTables;
        TokenStream.Marker marker = ddlContent.mark();
        try {
            while (ddlContent.hasNext()) {
                this.parseNextStatement(ddlContent.mark());
                this.tokens.canConsume(256);
            }
        }
        catch (ParsingException e) {
            ddlContent.rewind(marker);
            throw e;
        }
        catch (Throwable t) {
            this.parsingFailed(ddlContent.nextPosition(), "Unexpected exception (" + t.getMessage() + ") parsing", t);
        }
    }

    protected void parseNextStatement(TokenStream.Marker marker) {
        if (this.tokens.matches(32)) {
            this.parseComment(marker);
        } else if (this.tokens.matches("CREATE")) {
            this.parseCreate(marker);
        } else if (this.tokens.matches("ALTER")) {
            this.parseAlter(marker);
        } else if (this.tokens.matches("DROP")) {
            this.parseDrop(marker);
        } else {
            this.parseUnknownStatement(marker);
        }
    }

    protected void parseComment(TokenStream.Marker marker) {
        String comment = this.tokens.consume();
        this.logger.trace("COMMENT: {}", (Object)comment);
    }

    protected void parseCreate(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseAlter(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseDrop(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void parseUnknownStatement(TokenStream.Marker marker) {
        this.consumeStatement();
    }

    protected void signalEvent(DdlParserListener.Event event) {
        if (event != null && !this.listeners.isEmpty()) {
            this.listeners.forEach(listener -> listener.handle(event));
        }
    }

    protected void signalCreateDatabase(String databaseName, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.DatabaseCreatedEvent(databaseName, this.statement(statementStart)));
    }

    protected void signalAlterDatabase(String databaseName, String previousDatabaseName, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.DatabaseAlteredEvent(databaseName, previousDatabaseName, this.statement(statementStart)));
    }

    protected void signalDropDatabase(String databaseName, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.DatabaseCreatedEvent(databaseName, this.statement(statementStart)));
    }

    protected void signalCreateTable(TableId id, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableCreatedEvent(id, this.statement(statementStart), false));
    }

    protected void signalAlterTable(TableId id, TableId previousId, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableAlteredEvent(id, previousId, this.statement(statementStart), false));
    }

    protected void signalAlterTable(TableId id, TableId previousId, String statement) {
        this.signalEvent(new DdlParserListener.TableAlteredEvent(id, previousId, statement, false));
    }

    protected void signalDropTable(TableId id, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableDroppedEvent(id, this.statement(statementStart), false));
    }

    protected void signalDropTable(TableId id, String statement) {
        this.signalEvent(new DdlParserListener.TableDroppedEvent(id, statement, false));
    }

    protected void signalCreateView(TableId id, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableCreatedEvent(id, this.statement(statementStart), true));
    }

    protected void signalAlterView(TableId id, TableId previousId, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableAlteredEvent(id, previousId, this.statement(statementStart), true));
    }

    protected void signalDropView(TableId id, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableDroppedEvent(id, this.statement(statementStart), true));
    }

    protected void signalDropView(TableId id, String statement) {
        this.signalEvent(new DdlParserListener.TableDroppedEvent(id, statement, true));
    }

    protected void signalCreateIndex(String indexName, TableId id, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableIndexCreatedEvent(indexName, id, this.statement(statementStart)));
    }

    protected void signalDropIndex(String indexName, TableId id, TokenStream.Marker statementStart) {
        this.signalEvent(new DdlParserListener.TableIndexDroppedEvent(indexName, id, this.statement(statementStart)));
    }

    protected void debugParsed(TokenStream.Marker statementStart) {
        if (this.logger.isTraceEnabled()) {
            String statement = this.statement(statementStart);
            this.logger.trace("PARSED:  {}", (Object)statement);
        }
    }

    protected void debugSkipped(TokenStream.Marker statementStart) {
        if (this.logger.isTraceEnabled()) {
            String statement = this.statement(statementStart);
            this.logger.trace("SKIPPED: {}", (Object)statement);
        }
    }

    protected String statement(TokenStream.Marker statementStart) {
        return this.removeLineFeeds(this.tokens.getContentFrom(statementStart));
    }

    private String removeLineFeeds(String input) {
        return input.replaceAll("[\\n|\\t]", "");
    }

    protected void consumeStatement() throws ParsingException {
        TokenStream.Marker start = this.tokens.mark();
        this.tokens.consume(128);
        this.consumeRemainingStatement(start);
    }

    protected void consumeRemainingStatement(TokenStream.Marker start) {
        while (this.tokens.hasNext() && !this.tokens.matches(128)) {
            if (this.tokens.matches("BEGIN")) {
                this.consumeBeginStatement(this.tokens.mark());
            } else if (this.tokens.matches(256)) {
                this.tokens.consume();
                break;
            }
            if (!this.tokens.hasNext()) {
                return;
            }
            this.tokens.consume();
        }
    }

    protected void consumeBeginStatement(TokenStream.Marker start) {
        this.tokens.consume("BEGIN");
        this.tokens.consumeThrough("END");
        while (this.tokens.canConsume("IF")) {
            this.tokens.consumeThrough("END");
        }
    }

    protected String consumeSingleQuotedString() {
        return this.tokens.consumeAnyOf(8);
    }

    protected String consumeDoubleQuotedString() {
        return this.tokens.consumeAnyOf(16);
    }

    protected String consumeQuotedString() {
        return this.tokens.consumeAnyOf(8, 16);
    }

    protected void parsingFailed(Position position, String msg) {
        this.parsingFailed(position, msg, null);
    }

    protected void parsingFailed(Position position, String msg, Throwable t) {
        throw new ParsingException(position, msg + " at line " + position.line() + ", column " + position.column(), t);
    }

    protected void parsingFailed(Position position, Collection<ParsingException> errors, String msg) {
        if (errors == null || errors.isEmpty()) {
            throw new ParsingException(position, msg + " at line " + position.line() + ", column " + position.column());
        }
        throw new MultipleParsingExceptions(msg + " at line " + position.line() + ", column " + position.column(), errors);
    }

    protected Collection<ParsingException> accumulateParsingFailure(ParsingException e, Collection<ParsingException> list) {
        if (e == null) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<ParsingException>();
        }
        list.add(e);
        return list;
    }

    protected Collection<ParsingException> accumulateParsingFailure(MultipleParsingExceptions e, Collection<ParsingException> list) {
        if (e == null) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<ParsingException>();
        }
        list.addAll(e.getErrors());
        return list;
    }

    protected Object parseLiteral(TokenStream.Marker start) {
        if (this.tokens.canConsume('_')) {
            this.parseCharacterSetName(start);
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("N")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("U", "&")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.canConsume("X")) {
            return this.parseCharacterLiteral(start);
        }
        if (this.tokens.matchesAnyOf(16, 8)) {
            return this.tokens.consume();
        }
        if (this.tokens.canConsume("B")) {
            return this.parseBitFieldLiteral(start);
        }
        if (this.tokens.canConsume("DATE")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TIME")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TIMESTAMP")) {
            return this.parseDateLiteral(start);
        }
        if (this.tokens.canConsume("TRUE")) {
            return Boolean.TRUE;
        }
        if (this.tokens.canConsume("FALSE")) {
            return Boolean.FALSE;
        }
        if (this.tokens.canConsume("UNKNOWN")) {
            return Boolean.FALSE;
        }
        return this.parseNumericLiteral(start, true);
    }

    protected Object parseNumericLiteral(TokenStream.Marker start, boolean signed) {
        StringBuilder sb = new StringBuilder();
        boolean decimal = false;
        if (signed && this.tokens.matches("+", "-")) {
            sb.append(this.tokens.consumeAnyOf("+", "-"));
        }
        if (!this.tokens.canConsume('.')) {
            sb.append(this.tokens.consumeInteger());
        }
        if (this.tokens.canConsume('.')) {
            sb.append(this.tokens.consumeInteger());
            decimal = true;
        }
        if (!this.tokens.canConsume('E')) {
            if (decimal) {
                return Double.parseDouble(sb.toString());
            }
            return Integer.parseInt(sb.toString());
        }
        sb.append('E');
        if (this.tokens.matches("+", "-")) {
            sb.append(this.tokens.consumeAnyOf("+", "-"));
        }
        sb.append(this.tokens.consumeInteger());
        return new BigDecimal(sb.toString());
    }

    protected String parseCharacterLiteral(TokenStream.Marker start) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            if (this.tokens.matches(32)) {
                this.parseComment(start);
                continue;
            }
            if (!this.tokens.matchesAnyOf(8, 16)) break;
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(this.tokens.consume());
        }
        if (this.tokens.canConsume("ESCAPE")) {
            this.tokens.consume();
        }
        return sb.toString();
    }

    protected String parseCharacterSetName(TokenStream.Marker start) {
        String name = this.tokens.consume();
        if (this.tokens.canConsume('.')) {
            String id = this.tokens.consume();
            return name + "." + id;
        }
        return name;
    }

    protected String parseBitFieldLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseDateLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseTimeLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected String parseTimestampLiteral(TokenStream.Marker start) {
        return this.consumeQuotedString();
    }

    protected Map<String, Column> parseColumnsInSelectClause(TokenStream.Marker start) {
        LinkedHashMap<String, String> tableAliasByColumnAlias = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> columnNameByAliases = new LinkedHashMap<String, String>();
        this.parseColumnName(start, tableAliasByColumnAlias, columnNameByAliases);
        while (this.tokens.canConsume(',')) {
            this.parseColumnName(start, tableAliasByColumnAlias, columnNameByAliases);
        }
        TokenStream.Marker startOfFrom = this.tokens.mark();
        LinkedHashMap<String, Column> columnsByName = new LinkedHashMap<String, Column>();
        Map<String, Table> fromTablesByAlias = this.parseSelectFromClause(start);
        Table singleTable = fromTablesByAlias.size() == 1 ? fromTablesByAlias.values().stream().findFirst().get() : null;
        tableAliasByColumnAlias.forEach((columnAlias, tableAlias) -> {
            String columnName = columnNameByAliases.getOrDefault(columnAlias, (String)columnAlias);
            Column column = null;
            if (tableAlias == null) {
                column = singleTable == null ? null : singleTable.columnWithName(columnName);
            } else {
                Table table = (Table)fromTablesByAlias.get(tableAlias);
                Column column2 = column = table == null ? null : table.columnWithName(columnName);
            }
            if (column == null) {
                column = this.createColumnFromConstant((String)columnAlias, columnName);
            }
            columnsByName.put((String)columnAlias, column);
        });
        this.tokens.rewind(startOfFrom);
        return columnsByName;
    }

    protected Column createColumnFromConstant(String columnName, String constantValue) {
        ColumnEditor column = Column.editor().name(columnName);
        try {
            if (constantValue.startsWith("'") || constantValue.startsWith("\"")) {
                column.type("CHAR");
                column.jdbcType(1);
                column.length(constantValue.length() - 2);
            } else if (constantValue.equalsIgnoreCase("TRUE") || constantValue.equalsIgnoreCase("FALSE")) {
                column.type("BOOLEAN");
                column.jdbcType(16);
            } else {
                this.setTypeInfoForConstant(constantValue, column);
            }
        }
        catch (Throwable t) {
            this.logger.debug("Unable to create an artificial column for the constant: " + constantValue);
        }
        return column.create();
    }

    protected void setTypeInfoForConstant(String constantValue, ColumnEditor column) {
        try {
            Integer.parseInt(constantValue);
            column.type("INTEGER");
            column.jdbcType(4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Long.parseLong(constantValue);
            column.type("BIGINT");
            column.jdbcType(-5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Float.parseFloat(constantValue);
            column.type("FLOAT");
            column.jdbcType(6);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Double.parseDouble(constantValue);
            column.type("DOUBLE");
            column.jdbcType(8);
            int precision = 0;
            int scale = 0;
            boolean foundDecimalPoint = false;
            for (int i = 0; i < constantValue.length(); ++i) {
                char c = constantValue.charAt(i);
                if (c == '+' || c == '-') continue;
                if (c == '.') {
                    foundDecimalPoint = true;
                    continue;
                }
                if (!Character.isDigit(c)) break;
                if (foundDecimalPoint) {
                    ++scale;
                    continue;
                }
                ++precision;
            }
            column.length(precision);
            column.scale(scale);
        }
        catch (NumberFormatException precision) {
            // empty catch block
        }
        try {
            BigDecimal decimal = new BigDecimal(constantValue);
            column.type("DECIMAL");
            column.jdbcType(3);
            column.length(decimal.precision());
            column.scale(decimal.precision());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String determineTypeNameForConstant(long value) {
        return "BIGINT";
    }

    protected String determineTypeNameForConstant(float value) {
        return "FLOAT";
    }

    protected String determineTypeNameForConstant(double value) {
        return "DECIMAL";
    }

    protected String determineTypeNameForConstant(BigDecimal value) {
        return "BIGINT";
    }

    protected void parseColumnName(TokenStream.Marker start, Map<String, String> tableAliasByColumnAliases, Map<String, String> columnNameByAliases) {
        try {
            String tableName = this.tokens.consume();
            String columnName = null;
            if (this.tokens.canConsume('.')) {
                columnName = this.tokens.consume();
            } else {
                columnName = tableName;
                tableName = null;
            }
            String alias = columnName;
            if (this.tokens.canConsume("AS")) {
                alias = this.tokens.consume();
            }
            columnNameByAliases.put(alias, columnName);
            tableAliasByColumnAliases.put(alias, tableName);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    protected Map<String, Table> parseSelectFromClause(TokenStream.Marker start) {
        HashMap<String, Table> tablesByAlias = new HashMap<String, Table>();
        if (this.tokens.canConsume("FROM")) {
            try {
                this.parseAliasedTableInFrom(start, tablesByAlias);
                while (this.tokens.canConsume(',') || this.canConsumeJoin(start)) {
                    this.parseAliasedTableInFrom(start, tablesByAlias);
                    this.canConsumeJoinCondition(start);
                }
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return tablesByAlias;
    }

    protected boolean canConsumeJoin(TokenStream.Marker start) {
        return this.tokens.canConsume("JOIN") || this.tokens.canConsume("INNER", "JOIN") || this.tokens.canConsume("OUTER", "JOIN") || this.tokens.canConsume("CROSS", "JOIN") || this.tokens.canConsume("RIGHT", "OUTER", "JOIN") || this.tokens.canConsume("LEFT", "OUTER", "JOIN") || this.tokens.canConsume("FULL", "OUTER", "JOIN");
    }

    protected boolean canConsumeJoinCondition(TokenStream.Marker start) {
        if (this.tokens.canConsume("ON")) {
            try {
                this.parseSchemaQualifiedName(start);
                while (this.tokens.canConsume(2)) {
                }
                this.parseSchemaQualifiedName(start);
                return true;
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return false;
    }

    private void parseAliasedTableInFrom(TokenStream.Marker start, Map<String, Table> tablesByAlias) {
        Table fromTable = this.databaseTables.forTable(this.parseQualifiedTableName(start));
        if (this.tokens.matches("AS", "any value", "ON") || this.tokens.matches("any value", "ON")) {
            this.tokens.canConsume("AS");
            String alias = this.tokens.consume();
            if (fromTable != null) {
                tablesByAlias.put(alias, fromTable);
                return;
            }
        }
        if (fromTable != null) {
            tablesByAlias.put(fromTable.id().table(), fromTable);
        }
    }

    protected static interface TokenSet {
        public void add(String var1);

        default public void add(String firstToken, String ... additionalTokens) {
            this.add(firstToken);
            for (String token : additionalTokens) {
                this.add(token);
            }
        }
    }
}

