/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.crdt;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.crdt.Count;
import io.debezium.crdt.GCount;
import io.debezium.crdt.PNCount;
import io.debezium.crdt.PNCounter;

@NotThreadSafe
class StateBasedPNCounter
implements PNCounter {
    private long adds;
    private long removes;

    protected StateBasedPNCounter() {
        this(0L, 0L);
    }

    protected StateBasedPNCounter(long adds, long removes) {
        this.adds = adds;
        this.removes = removes;
    }

    @Override
    public PNCounter increment() {
        ++this.adds;
        return this;
    }

    @Override
    public PNCounter decrement() {
        ++this.removes;
        return this;
    }

    @Override
    public long incrementAndGet() {
        return ++this.adds - this.removes;
    }

    @Override
    public long decrementAndGet() {
        return this.adds - ++this.removes;
    }

    @Override
    public long getAndIncrement() {
        return this.adds++ - this.removes;
    }

    @Override
    public long getAndDecrement() {
        return this.adds - this.removes++;
    }

    @Override
    public long get() {
        return this.adds - this.removes;
    }

    @Override
    public long getIncrement() {
        return this.adds;
    }

    @Override
    public long getDecrement() {
        return this.removes;
    }

    @Override
    public PNCounter merge(Count other) {
        if (other instanceof PNCount) {
            PNCount changes = (PNCount)other;
            this.adds += changes.getIncrement();
            this.removes += changes.getDecrement();
        } else if (other instanceof GCount) {
            GCount changes = (GCount)other;
            this.adds += changes.getIncrement();
        } else if (other instanceof Count) {
            Count changes = other;
            this.adds += changes.get();
        }
        return this;
    }

    public String toString() {
        return "+" + this.adds + " -" + this.removes;
    }
}

