/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.TopicSelector;
import io.debezium.data.Envelope;
import io.debezium.data.Json;
import io.debezium.function.BlockingConsumer;
import io.debezium.util.AvroValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RecordMakers {
    private static final Map<String, Envelope.Operation> operationLiterals = new HashMap<String, Envelope.Operation>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AvroValidator schemaNameValidator = AvroValidator.create((Logger)this.logger);
    private final SourceInfo source;
    private final TopicSelector topicSelector;
    private final Map<CollectionId, RecordsForCollection> recordMakerByCollectionId = new HashMap<CollectionId, RecordsForCollection>();
    private final Function<Document, String> valueTransformer;
    private final BlockingConsumer<SourceRecord> recorder;

    public RecordMakers(SourceInfo source, TopicSelector topicSelector, BlockingConsumer<SourceRecord> recorder) {
        this.source = source;
        this.topicSelector = topicSelector;
        JsonWriterSettings writerSettings = new JsonWriterSettings(JsonMode.STRICT, "", "");
        this.valueTransformer = doc -> doc.toJson(writerSettings);
        this.recorder = recorder;
    }

    public RecordsForCollection forCollection(CollectionId collectionId) {
        return this.recordMakerByCollectionId.computeIfAbsent(collectionId, id -> {
            String topicName = this.topicSelector.getTopic(collectionId);
            return new RecordsForCollection(collectionId, this.source, topicName, this.schemaNameValidator, this.valueTransformer, this.recorder);
        });
    }

    public void clear() {
        this.logger.debug("Clearing table converters");
        this.recordMakerByCollectionId.clear();
    }

    static {
        operationLiterals.put("i", Envelope.Operation.CREATE);
        operationLiterals.put("u", Envelope.Operation.UPDATE);
        operationLiterals.put("d", Envelope.Operation.DELETE);
    }

    public static final class RecordsForCollection {
        private final CollectionId collectionId;
        private final String replicaSetName;
        private final SourceInfo source;
        private final Map<String, ?> sourcePartition;
        private final String topicName;
        private final Schema keySchema;
        private final Schema valueSchema;
        private final Function<Document, String> valueTransformer;
        private final BlockingConsumer<SourceRecord> recorder;

        protected RecordsForCollection(CollectionId collectionId, SourceInfo source, String topicName, AvroValidator validator, Function<Document, String> valueTransformer, BlockingConsumer<SourceRecord> recorder) {
            this.sourcePartition = source.partition(collectionId.replicaSetName());
            this.collectionId = collectionId;
            this.replicaSetName = this.collectionId.replicaSetName();
            this.source = source;
            this.topicName = topicName;
            this.keySchema = SchemaBuilder.struct().name(validator.validate(topicName + ".Key")).field("_id", Schema.STRING_SCHEMA).build();
            this.valueSchema = SchemaBuilder.struct().name(validator.validate(topicName + ".Envelope")).field("after", Json.builder().optional().build()).field("patch", Json.builder().optional().build()).field("source", source.schema()).field("op", Schema.OPTIONAL_STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).build();
            JsonWriterSettings writerSettings = new JsonWriterSettings(JsonMode.STRICT, "", "");
            this.valueTransformer = doc -> doc.toJson(writerSettings);
            this.recorder = recorder;
        }

        public CollectionId collectionId() {
            return this.collectionId;
        }

        public int recordObject(CollectionId id, Document object, long timestamp) throws InterruptedException {
            Struct sourceValue = this.source.lastOffsetStruct(this.replicaSetName, id);
            Map<String, ?> offset = this.source.lastOffset(this.replicaSetName);
            String objId = this.objectIdLiteralFrom(object);
            return this.createRecords(sourceValue, offset, Envelope.Operation.READ, objId, object, timestamp);
        }

        public int recordEvent(Document oplogEvent, long timestamp) throws InterruptedException {
            String objId;
            Struct sourceValue = this.source.offsetStructForEvent(this.replicaSetName, oplogEvent);
            Map<String, ?> offset = this.source.lastOffset(this.replicaSetName);
            Document patchObj = (Document)oplogEvent.get((Object)"o", Document.class);
            Object o2 = oplogEvent.get((Object)"o2");
            String string = objId = o2 != null ? this.objectIdLiteral(o2) : this.objectIdLiteralFrom(patchObj);
            assert (objId != null);
            Envelope.Operation operation = (Envelope.Operation)operationLiterals.get(oplogEvent.getString((Object)"op"));
            return this.createRecords(sourceValue, offset, operation, objId, patchObj, timestamp);
        }

        protected int createRecords(Struct source, Map<String, ?> offset, Envelope.Operation operation, String objId, Document objectValue, long timestamp) throws InterruptedException {
            Integer partition = null;
            Struct key = this.keyFor(objId);
            Struct value = new Struct(this.valueSchema);
            switch (operation) {
                case READ: 
                case CREATE: {
                    String jsonStr = this.valueTransformer.apply(objectValue);
                    value.put("after", (Object)jsonStr);
                    break;
                }
                case UPDATE: {
                    String patchStr = this.valueTransformer.apply(objectValue);
                    value.put("patch", (Object)patchStr);
                    break;
                }
            }
            value.put("source", (Object)source);
            value.put("op", (Object)operation.code());
            value.put("ts_ms", (Object)timestamp);
            SourceRecord record = new SourceRecord(this.sourcePartition, offset, this.topicName, partition, this.keySchema, (Object)key, this.valueSchema, (Object)value);
            this.recorder.accept((Object)record);
            if (operation == Envelope.Operation.DELETE) {
                record = new SourceRecord(this.sourcePartition, offset, this.topicName, partition, this.keySchema, (Object)key, null, null);
                this.recorder.accept((Object)record);
                return 2;
            }
            return 1;
        }

        protected String objectIdLiteralFrom(Document obj) {
            if (obj == null) {
                return null;
            }
            Object id = obj.get((Object)"_id");
            return this.objectIdLiteral(id);
        }

        protected String objectIdLiteral(Object id) {
            if (id == null) {
                return null;
            }
            if (id instanceof ObjectId) {
                return ((ObjectId)id).toHexString();
            }
            if (id instanceof String) {
                return (String)id;
            }
            if (id instanceof Document) {
                Document doc = (Document)id;
                if (doc.containsKey((Object)"_id") && doc.size() == 1) {
                    return this.objectIdLiteral(doc.get((Object)"_id"));
                }
                return this.valueTransformer.apply((Document)id);
            }
            return id.toString();
        }

        protected Struct keyFor(String objId) {
            return new Struct(this.keySchema).put("_id", (Object)objId);
        }
    }
}

