/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;

public class Configurator {
    private Configuration.Builder configBuilder = Configuration.create();

    public Configurator with(Field field, String value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, boolean value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, int value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator serverName(String serverName) {
        return this.with(MongoDbConnectorConfig.LOGICAL_NAME, serverName);
    }

    public Configurator hosts(String hosts) {
        return this.with(MongoDbConnectorConfig.HOSTS, hosts);
    }

    public Configurator maxBatchSize(int maxBatchSize) {
        return this.with(MongoDbConnectorConfig.MAX_BATCH_SIZE, maxBatchSize);
    }

    public Configurator includeCollections(String regexList) {
        return this.with(MongoDbConnectorConfig.COLLECTION_WHITELIST, regexList);
    }

    public Configurator excludeCollections(String regexList) {
        return this.with(MongoDbConnectorConfig.COLLECTION_BLACKLIST, regexList);
    }

    public Filters createFilters() {
        return new Filters(this.configBuilder.build());
    }
}

