/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

@Immutable
public final class ColumnId
implements Comparable<ColumnId> {
    private final TableId tableId;
    private final String columnName;
    private final String id;

    public static Map<TableId, Predicate<Column>> filter(String columnBlacklist) {
        Set<ColumnId> columnExclusions = columnBlacklist == null ? null : Strings.listOf(columnBlacklist, ColumnId::parse);
        HashMap<TableId, Set> excludedColumnNamesByTable = new HashMap<TableId, Set>();
        columnExclusions.forEach(columnId -> excludedColumnNamesByTable.compute(columnId.tableId(), (tableId, columns) -> {
            if (columns == null) {
                columns = new HashSet<String>();
            }
            columns.add(columnId.columnName().toLowerCase());
            return columns;
        }));
        HashMap<TableId, Predicate<Column>> exclusionFilterByTable = new HashMap<TableId, Predicate<Column>>();
        excludedColumnNamesByTable.forEach((tableId, excludedColumnNames) -> exclusionFilterByTable.put((TableId)tableId, col -> !excludedColumnNames.contains(col.name().toLowerCase())));
        return exclusionFilterByTable;
    }

    public static ColumnId parse(String str) {
        return ColumnId.parse(str, '.', true);
    }

    public static ColumnId parse(String str, char delimiter, boolean useCatalogBeforeSchema) {
        String[] parts = str.split("[\\" + delimiter + "]");
        if (parts.length < 2) {
            return null;
        }
        TableId tableId = TableId.parse(parts, parts.length - 1, useCatalogBeforeSchema);
        if (tableId == null) {
            return null;
        }
        return new ColumnId(tableId, parts[parts.length - 1]);
    }

    public ColumnId(TableId tableId, String columnName) {
        this.tableId = tableId;
        this.columnName = columnName;
        assert (this.tableId != null);
        assert (this.columnName != null);
        this.id = ColumnId.columnId(this.tableId, this.columnName);
    }

    public ColumnId(String catalogName, String schemaName, String tableName, String columnName) {
        this(new TableId(catalogName, schemaName, tableName), columnName);
    }

    public TableId tableId() {
        return this.tableId;
    }

    public String catalog() {
        return this.tableId.catalog();
    }

    public String schema() {
        return this.tableId.schema();
    }

    public String table() {
        return this.tableId.table();
    }

    public String columnName() {
        return this.columnName;
    }

    @Override
    public int compareTo(ColumnId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public int compareToIgnoreCase(ColumnId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareToIgnoreCase(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnId) {
            return this.compareTo((ColumnId)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    private static String columnId(TableId tableId, String columnName) {
        return tableId.toString() + "." + columnName;
    }
}

