/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import java.util.StringJoiner;

@ThreadSafe
@FunctionalInterface
public interface TopicSelector {
    public static TopicSelector defaultSelector() {
        return TopicSelector.defaultSelector(null, ".");
    }

    public static TopicSelector defaultSelector(String prefix) {
        return TopicSelector.defaultSelector(prefix, ".");
    }

    public static TopicSelector defaultSelector(String prefix, String delimiter) {
        if (prefix != null && prefix.trim().length() > 0) {
            String trimmedPrefix = prefix.trim();
            return collectionId -> {
                StringJoiner sb = new StringJoiner(delimiter);
                sb.add(trimmedPrefix);
                sb.add(collectionId.dbName());
                sb.add(collectionId.name());
                return sb.toString();
            };
        }
        return collectionId -> {
            StringJoiner sb = new StringJoiner(delimiter);
            sb.add(collectionId.dbName());
            sb.add(collectionId.name());
            return sb.toString();
        };
    }

    public String getTopic(CollectionId var1);
}

