/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.ThreadSafe;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@ThreadSafe
public final class Strings {
    private static final String CURLY_PREFIX = "${";
    private static final String CURLY_SUFFIX = "}";
    private static final String VAR_DELIM = ",";
    private static final String DEFAULT_DELIM = ":";

    public static <T> Set<T> listOf(String input, Function<String, String[]> splitter, Function<String, T> factory) {
        if (input == null) {
            return Collections.emptySet();
        }
        HashSet<T> matches = new HashSet<T>();
        for (String item : splitter.apply(input)) {
            T obj = factory.apply(item);
            if (obj == null) continue;
            matches.add(obj);
        }
        return matches;
    }

    public static <T> Set<T> listOf(String input, char delimiter, Function<String, T> factory) {
        return Strings.listOf(input, str -> str.split("[" + delimiter + "]"), factory);
    }

    public static <T> Set<T> listOf(String input, Function<String, T> factory) {
        return Strings.listOf(input, ',', factory);
    }

    public static Set<Pattern> listOfRegex(String input) {
        return Strings.listOf(input, ',', Pattern::compile);
    }

    public static Set<Pattern> listOfRegex(String input, int regexFlags) {
        return Strings.listOf(input, ',', (String str) -> Pattern.compile(str, regexFlags));
    }

    public static List<String> splitLines(String content) {
        if (content == null || content.length() == 0) {
            return Collections.emptyList();
        }
        String[] lines = content.split("[\\r]?\\n");
        return Arrays.asList(lines);
    }

    public static int compareTo(CharSequence str1, CharSequence str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.toString().compareTo(str2.toString());
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String join(CharSequence delimiter, int[] values) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(values);
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return Integer.toString(values[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(values[0]);
        for (int i = 1; i != values.length; ++i) {
            sb.append(delimiter);
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public static <T> String join(CharSequence delimiter, Iterable<T> values) {
        return Strings.join(delimiter, values, v -> v != null ? v.toString() : null);
    }

    public static <T> String join(CharSequence delimiter, Iterable<T> values, Function<T, String> conversion) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(values);
        Iterator<T> iter = values.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(iter.next());
        while (iter.hasNext()) {
            String convertedValue = conversion.apply(iter.next());
            if (convertedValue == null) continue;
            sb.append(delimiter);
            sb.append(convertedValue);
        }
        return sb.toString();
    }

    public static String trim(String str) {
        return Strings.trim(str, c -> c <= ' ');
    }

    public static String trim(String str, CharacterPredicate predicate) {
        int st;
        int len = str.length();
        if (len == 0) {
            return str;
        }
        for (st = 0; st < len && predicate.test(str.charAt(st)); ++st) {
        }
        while (st < len && predicate.test(str.charAt(len - 1))) {
            --len;
        }
        return st > 0 || len < str.length() ? str.substring(st, len) : str;
    }

    public static String createString(char charToRepeat, int numberOfRepeats) {
        assert (numberOfRepeats >= 0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfRepeats; ++i) {
            sb.append(charToRepeat);
        }
        return sb.toString();
    }

    public static String pad(String original, int length, char padChar) {
        if (original.length() >= length) {
            return original;
        }
        StringBuilder sb = new StringBuilder(original);
        while (sb.length() < length) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String setLength(String original, int length, char padChar) {
        return Strings.justifyLeft(original, length, padChar, false);
    }

    public static String justify(Justify justify, String str, int width, char padWithChar) {
        switch (justify) {
            case LEFT: {
                return Strings.justifyLeft(str, width, padWithChar);
            }
            case RIGHT: {
                return Strings.justifyRight(str, width, padWithChar);
            }
            case CENTER: {
                return Strings.justifyCenter(str, width, padWithChar);
            }
        }
        assert (false);
        return null;
    }

    public static String justifyRight(String str, int width, char padWithChar) {
        assert (width > 0);
        int length = (str = str != null ? str.trim() : "").length();
        int addChars = width - length;
        if (addChars < 0) {
            return str.subSequence(length - width, length).toString();
        }
        StringBuilder sb = new StringBuilder();
        while (addChars > 0) {
            sb.append(padWithChar);
            --addChars;
        }
        sb.append(str);
        return sb.toString();
    }

    public static String justifyLeft(String str, int width, char padWithChar) {
        return Strings.justifyLeft(str, width, padWithChar, true);
    }

    protected static String justifyLeft(String str, int width, char padWithChar, boolean trimWhitespace) {
        int addChars;
        str = str != null ? (trimWhitespace ? str.trim() : str) : "";
        if (addChars < 0) {
            return str.subSequence(0, width).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        for (addChars = width - str.length(); addChars > 0; --addChars) {
            sb.append(padWithChar);
        }
        return sb.toString();
    }

    public static String justifyCenter(String str, int width, char padWithChar) {
        int prependNumber;
        int addChars = width - (str = str != null ? str.trim() : "").length();
        if (addChars < 0) {
            return str.subSequence(0, width).toString();
        }
        int appendNumber = prependNumber = addChars / 2;
        if (prependNumber + appendNumber != addChars) {
            ++prependNumber;
        }
        StringBuilder sb = new StringBuilder();
        while (prependNumber > 0) {
            sb.append(padWithChar);
            --prependNumber;
        }
        sb.append(str);
        while (appendNumber > 0) {
            sb.append(padWithChar);
            --appendNumber;
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bas);
        throwable.printStackTrace(pw);
        pw.close();
        return bas.toString();
    }

    public static Number asNumber(String value) {
        return Strings.asNumber(value, null);
    }

    public static Number asNumber(String value, Supplier<Number> defaultValueProvider) {
        if (value != null) {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e1) {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException e2) {
                    try {
                        return Long.valueOf(value);
                    }
                    catch (NumberFormatException e3) {
                        try {
                            return Float.valueOf(value);
                        }
                        catch (NumberFormatException e4) {
                            try {
                                return Double.valueOf(value);
                            }
                            catch (NumberFormatException e5) {
                                try {
                                    return new BigInteger(value);
                                }
                                catch (NumberFormatException e6) {
                                    try {
                                        return new BigDecimal(value);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return defaultValueProvider != null ? (Number)defaultValueProvider.get() : (Number)null;
    }

    public static int asInt(String value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long asLong(String value, long defaultValue) {
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double asDouble(String value, double defaultValue) {
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean asBoolean(String value, boolean defaultValue) {
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String duration(long durationInMillis) {
        BigDecimal bigSeconds = new BigDecimal(Math.abs(durationInMillis)).divide(new BigDecimal(1000));
        int minutes = bigSeconds.intValue() / 60;
        double dMinutes = minutes;
        double seconds = bigSeconds.doubleValue() - dMinutes * 60.0;
        int hours = minutes / 60;
        String result = new DecimalFormat("######00").format(hours) + ':' + new DecimalFormat("00").format(minutes -= hours * 60) + ':' + new DecimalFormat("00.0##").format(seconds);
        return result;
    }

    public static Function<String, String> replaceVariablesWith(Function<String, String> replacementsByVariableName) {
        return value -> Strings.replaceVariables(value, replacementsByVariableName);
    }

    public static String replaceVariables(String value, Function<String, String> replacementsByVariableName) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value);
        int startName = sb.indexOf(CURLY_PREFIX);
        if (startName == -1) {
            return value;
        }
        while (startName != -1) {
            String var;
            String defaultValue = null;
            int endName = sb.indexOf(CURLY_SUFFIX, startName);
            if (endName == -1) {
                return sb.toString();
            }
            String varString = sb.substring(startName + 2, endName);
            if (varString.indexOf(DEFAULT_DELIM) > -1) {
                List<String> defaults = Strings.split(varString, DEFAULT_DELIM);
                varString = defaults.get(0);
                if (defaults.size() == 2) {
                    defaultValue = defaults.get(1);
                }
            }
            String constValue = null;
            List<String> vars = Strings.split(varString, VAR_DELIM);
            Iterator<String> iterator = vars.iterator();
            while (iterator.hasNext() && (constValue = replacementsByVariableName.apply(var = iterator.next())) == null) {
            }
            if (constValue == null && defaultValue != null) {
                constValue = defaultValue;
            }
            if (constValue != null) {
                sb = sb.replace(startName, endName + 1, constValue);
                startName = sb.indexOf(CURLY_PREFIX);
                continue;
            }
            startName = sb.indexOf(CURLY_PREFIX, endName);
        }
        return sb.toString();
    }

    private static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static boolean isUuid(String str) {
        if (str == null) {
            return false;
        }
        try {
            UUID.fromString(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Strings() {
    }

    public static enum Justify {
        LEFT,
        RIGHT,
        CENTER;

    }

    @FunctionalInterface
    public static interface CharacterPredicate {
        public boolean test(char var1);
    }
}

