/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicationContext;
import io.debezium.data.Envelope;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MongoDbConnectorIT
extends AbstractConnectorTest {
    private Configuration config;
    private ReplicationContext context;

    @Before
    public void beforeEach() {
        Testing.Debug.disable();
        Testing.Print.disable();
        this.stopConnector();
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            if (this.context != null) {
                this.context.shutdown();
            }
        }
    }

    @Test
    public void shouldNotStartWithInvalidConfiguration() {
        this.config = ((Configuration.Builder)Configuration.create().with(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, "true")).build();
        this.logger.info("Attempting to start the connector with an INVALID configuration, so MULTIPLE error messages & one exceptions will appear in the log");
        this.start(MongoDbConnector.class, this.config, (success, msg, error) -> {
            Assertions.assertThat((boolean)success).isFalse();
            Assertions.assertThat((Throwable)error).isNotNull();
        });
        this.assertConnectorNotRunning();
    }

    @Test
    public void shouldFailToValidateInvalidConfiguration() {
        Configuration config = Configuration.create().build();
        MongoDbConnector connector = new MongoDbConnector();
        Config result = connector.validate(config.asMap());
        this.assertConfigurationErrors(result, MongoDbConnectorConfig.HOSTS, 1);
        this.assertConfigurationErrors(result, MongoDbConnectorConfig.LOGICAL_NAME, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.DATABASE_LIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_COPY_THREADS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_INITIAL_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_MAX_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS});
    }

    @Test
    public void shouldValidateAcceptableConfiguration() {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MongoDbConnectorConfig.HOSTS, System.getProperty("connector.mongodb.hosts"))).with(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, System.getProperty("connector.mongodb.members.auto.discover"))).with(MongoDbConnectorConfig.LOGICAL_NAME, System.getProperty("connector.mongodb.name"))).build();
        this.context = new ReplicationContext(this.config);
        this.storeDocuments("dbval", "validationColl1", "simple_objects.json");
        this.storeDocuments("dbval2", "validationColl2", "restaurants1.json");
        MongoDbConnector connector = new MongoDbConnector();
        Config result = connector.validate(this.config.asMap());
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.HOSTS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.LOGICAL_NAME});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.DATABASE_LIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_COPY_THREADS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_INITIAL_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_MAX_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS});
        Field.Recommender dbNameRecommender = MongoDbConnectorConfig.DATABASE_LIST.recommender();
        List dbNames = dbNameRecommender.validValues(MongoDbConnectorConfig.DATABASE_LIST, this.config);
        Testing.debug((Object)("List of dbNames: " + dbNames));
        Assertions.assertThat((List)dbNames).contains(new Object[]{"dbval", "dbval2"});
        Field.Recommender collectionNameRecommender = MongoDbConnectorConfig.COLLECTION_WHITELIST.recommender();
        List collectionNames = collectionNameRecommender.validValues(MongoDbConnectorConfig.COLLECTION_WHITELIST, this.config);
        Testing.debug((Object)("List of collection names: " + collectionNames));
        Assertions.assertThat((List)collectionNames).isEmpty();
        Configuration config2 = ((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.DATABASE_LIST, "dbval")).build();
        List collectionNames2 = collectionNameRecommender.validValues(MongoDbConnectorConfig.COLLECTION_WHITELIST, config2);
        Assertions.assertThat((List)collectionNames2).containsOnly(new Object[]{"dbval.validationColl1"});
        Testing.debug((Object)("List of collection names: " + collectionNames2));
    }

    @Test
    public void shouldConsumeAllEventsFromDatabase() throws InterruptedException, IOException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(MongoDbConnectorConfig.HOSTS, System.getProperty("connector.mongodb.hosts"))).with(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, System.getProperty("connector.mongodb.members.auto.discover"))).with(MongoDbConnectorConfig.LOGICAL_NAME, System.getProperty("connector.mongodb.name"))).with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new ReplicationContext(this.config);
        this.storeDocuments("dbit", "simpletons", "simple_objects.json");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.simpletons").size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.storeDocuments("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        Assertions.assertThat((int)records2.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(4);
        Assertions.assertThat((int)records2.topics().size()).isEqualTo(1);
        records2.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        this.stopConnector();
        this.storeDocuments("dbit", "restaurants", "restaurants3.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records3 = this.consumeRecordsByTopic(5);
        Assertions.assertThat((int)records3.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(5);
        Assertions.assertThat((int)records3.topics().size()).isEqualTo(1);
        records3.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        this.storeDocuments("dbit", "restaurants", "restaurants4.json");
        AbstractConnectorTest.SourceRecords records4 = this.consumeRecordsByTopic(8);
        Assertions.assertThat((int)records4.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(8);
        Assertions.assertThat((int)records4.topics().size()).isEqualTo(1);
        records4.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        AtomicReference id = new AtomicReference();
        this.primary().execute("create", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("arbitrary");
            coll.drop();
            Document doc = Document.parse((String)"{\"a\": 1, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
            id.set(doc.getObjectId((Object)"_id").toString());
            Testing.debug((Object)("Document ID: " + (String)id.get()));
        });
        this.primary().execute("update", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("arbitrary");
            Document doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
            Document filter = Document.parse((String)"{\"a\": 1}");
            Document operation = Document.parse((String)"{ \"$set\": { \"b\": 10 } }");
            coll.updateOne((Bson)filter, (Bson)operation);
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
        });
        AbstractConnectorTest.SourceRecords insertAndUpdate = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)insertAndUpdate.recordsForTopic("mongo.dbit.arbitrary").size()).isEqualTo(2);
        Assertions.assertThat((int)insertAndUpdate.topics().size()).isEqualTo(1);
        records4.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        SourceRecord insertRecord = (SourceRecord)insertAndUpdate.allRecordsInOrder().get(0);
        SourceRecord updateRecord = (SourceRecord)insertAndUpdate.allRecordsInOrder().get(1);
        Testing.debug((Object)("Insert event: " + insertRecord));
        Testing.debug((Object)("Update event: " + updateRecord));
        Struct insertKey = (Struct)insertRecord.key();
        Struct updateKey = (Struct)updateRecord.key();
        String insertId = insertKey.getString("_id");
        String updatetId = updateKey.getString("_id");
        Assertions.assertThat((String)insertId).isEqualTo(id.get());
        Assertions.assertThat((String)updatetId).isEqualTo(id.get());
    }

    protected void verifyFromInitialSync(SourceRecord record, AtomicBoolean foundLast) {
        if (record.sourceOffset().containsKey("initsync")) {
            Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isTrue();
            Struct value = (Struct)record.value();
            Assertions.assertThat((Boolean)value.getStruct("source").getBoolean("initsync")).isTrue();
        } else {
            Assertions.assertThat((boolean)foundLast.getAndSet(true)).isFalse();
        }
    }

    protected void verifyNotFromInitialSync(SourceRecord record) {
        Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isFalse();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Boolean)value.getStruct("source").getBoolean("initsync")).isNull();
    }

    protected void verifyCreateOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.CREATE);
    }

    protected void verifyReadOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.READ);
    }

    protected void verifyUpdateOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.UPDATE);
    }

    protected void verifyDeleteOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.DELETE);
    }

    protected void verifyOperation(SourceRecord record, Envelope.Operation expected) {
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)expected.code());
    }

    protected ConnectionContext.MongoPrimary primary() {
        ReplicaSet replicaSet = ReplicaSet.parse((String)this.context.hosts());
        return this.context.primaryFor(replicaSet, this.connectionErrorHandler(3));
    }

    protected void storeDocuments(String dbName, String collectionName, String pathOnClasspath) {
        this.primary().execute("storing documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' documents loaded from from '" + pathOnClasspath + "'"));
            MongoDatabase db1 = mongo.getDatabase(dbName);
            MongoCollection coll = db1.getCollection(collectionName);
            coll.drop();
            this.storeDocuments((MongoCollection<Document>)coll, pathOnClasspath);
        });
    }

    protected void storeDocuments(MongoCollection<Document> collection, String pathOnClasspath) {
        InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
        this.loadTestDocuments(pathOnClasspath).forEach(doc -> {
            Assertions.assertThat((Map)doc).isNotNull();
            Assertions.assertThat((int)doc.size()).isGreaterThan(0);
            collection.insertOne(doc, insertOptions);
        });
    }

    protected List<Document> loadTestDocuments(String pathOnClasspath) {
        ArrayList<Document> results = new ArrayList<Document>();
        try (InputStream stream = Testing.Files.readResourceAsStream((String)pathOnClasspath);){
            Assertions.assertThat((Object)stream).isNotNull();
            IoUtil.readLines((InputStream)stream, line -> {
                Document doc = Document.parse((String)line);
                Assertions.assertThat((int)doc.size()).isGreaterThan(0);
                results.add(doc);
            });
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to find or read file '" + pathOnClasspath + "': " + e.getMessage()));
        }
        return results;
    }

    protected BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            this.logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }
}

