/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Configurator;
import io.debezium.connector.mongodb.Filters;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FiltersTest {
    private Configurator build;
    private Filters filters;

    @Before
    public void beforeEach() {
        this.build = new Configurator();
        this.filters = null;
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralWithPeriodAsWildcardInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.coll[.]?ection[x]?A,db1[.](.*)B").createFilters();
        this.assertCollectionIncluded("db1xcoll.ectionA");
        this.assertCollectionIncluded("db1.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralWithEscapedPeriodInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1[.]collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.filters = this.build.includeCollections("db1\\.collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleLiteralsInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.collectionA,db1.collectionB").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleRegexInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.collection[x]?A,db1[.](.*)B").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionxA");
        this.assertCollectionExcluded("db1.collectionx");
        this.assertCollectionExcluded("db1.collectioxA");
        this.assertCollectionIncluded("db1.B");
        this.assertCollectionIncluded("db1.collB");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionxA");
        this.assertCollectionExcluded("db2.B");
        this.assertCollectionExcluded("db2.collB");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByRegexWithWildcardInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1[.](.*)").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionxA");
        this.assertCollectionIncluded("db1.collectionx");
        this.assertCollectionIncluded("db1.collectioxA");
        this.assertCollectionIncluded("db1.B");
        this.assertCollectionIncluded("db1.collB");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionxA");
        this.assertCollectionExcluded("db12.B");
        this.assertCollectionExcluded("db12.collB");
        this.assertCollectionExcluded("db12.collectionB");
    }

    @Test
    public void shouldExcludeCollectionCoveredByLiteralInBlacklist() {
        this.filters = this.build.excludeCollections("db1.collectionA").createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionIncluded("db2.collectionA");
    }

    protected void assertCollectionIncluded(String fullyQualifiedTableName) {
        CollectionId id = CollectionId.parse((String)("rs1." + fullyQualifiedTableName));
        Assertions.assertThat((Object)id).isNotNull();
        Assertions.assertThat((boolean)this.filters.collectionFilter().test(id)).isTrue();
    }

    protected void assertCollectionExcluded(String fullyQualifiedTableName) {
        CollectionId id = CollectionId.parse((String)("rs1." + fullyQualifiedTableName));
        Assertions.assertThat((Object)id).isNotNull();
        Assertions.assertThat((boolean)this.filters.collectionFilter().test(id)).isFalse();
    }
}

