/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.RecordMakers;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.TopicSelector;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class RecordMakersTest {
    private static final String SERVER_NAME = "serverX.";
    private static final String PREFIX = "serverX..";
    private static final JsonWriterSettings WRITER_SETTINGS = new JsonWriterSettings(JsonMode.STRICT, "", "");
    private SourceInfo source;
    private RecordMakers recordMakers;
    private TopicSelector topicSelector;
    private List<SourceRecord> produced;

    @Before
    public void beforeEach() {
        this.source = new SourceInfo(SERVER_NAME);
        this.topicSelector = TopicSelector.defaultSelector((String)PREFIX);
        this.produced = new ArrayList<SourceRecord>();
        this.recordMakers = new RecordMakers(this.source, this.topicSelector, this.produced::add);
    }

    @Test
    public void shouldAlwaysFindRecordMakerForCollection() {
        for (int i = 0; i != 100; ++i) {
            CollectionId id = new CollectionId("rs0", "dbA", "c" + i);
            RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(id);
            Assertions.assertThat((Object)records).isNotNull();
            Assertions.assertThat((Object)records.collectionId()).isSameAs((Object)id);
        }
    }

    @Test
    public void shouldGenerateRecordForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally");
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)new Long(12345678L)).append("op", (Object)"i");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        Struct key = (Struct)record.key();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)record.keySchema());
        Assertions.assertThat((Object)key.get("_id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)record.valueSchema());
        Assertions.assertThat((String)value.getString("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
        Assertions.assertThat((Long)value.getInt64("ts_ms")).isEqualTo(1002L);
        Struct actualSource = value.getStruct("source");
        Struct expectedSource = this.source.lastOffsetStruct("rs0", collectionId);
        Assertions.assertThat((Object)actualSource).isEqualTo((Object)expectedSource);
    }

    @Test
    public void shouldGenerateRecordForUpdateEvent() throws InterruptedException {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document("name", (Object)"Sally"));
        Document event = new Document().append("o", (Object)obj).append("o2", (Object)objId).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)new Long(12345678L)).append("op", (Object)"u");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(1);
        SourceRecord record = this.produced.get(0);
        Struct key = (Struct)record.key();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)record.keySchema());
        Assertions.assertThat((Object)key.get("_id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)record.valueSchema());
        Assertions.assertThat((String)value.getString("after")).isNull();
        Assertions.assertThat((String)value.getString("patch")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
        Assertions.assertThat((Long)value.getInt64("ts_ms")).isEqualTo(1002L);
        Struct actualSource = value.getStruct("source");
        Struct expectedSource = this.source.lastOffsetStruct("rs0", collectionId);
        Assertions.assertThat((Object)actualSource).isEqualTo((Object)expectedSource);
    }

    @Test
    public void shouldGenerateRecordForDeleteEvent() throws InterruptedException {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Document event = new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)new Long(12345678L)).append("op", (Object)"d");
        RecordMakers.RecordsForCollection records = this.recordMakers.forCollection(collectionId);
        records.recordEvent(event, 1002L);
        Assertions.assertThat((int)this.produced.size()).isEqualTo(2);
        SourceRecord record = this.produced.get(0);
        Struct key = (Struct)record.key();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)key.schema()).isSameAs((Object)record.keySchema());
        Assertions.assertThat((Object)key.get("_id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)value.schema()).isSameAs((Object)record.valueSchema());
        Assertions.assertThat((String)value.getString("after")).isNull();
        Assertions.assertThat((String)value.getString("patch")).isNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
        Assertions.assertThat((Long)value.getInt64("ts_ms")).isEqualTo(1002L);
        Struct actualSource = value.getStruct("source");
        Struct expectedSource = this.source.lastOffsetStruct("rs0", collectionId);
        Assertions.assertThat((Object)actualSource).isEqualTo((Object)expectedSource);
        SourceRecord tombstone = this.produced.get(1);
        Struct key2 = (Struct)tombstone.key();
        Assertions.assertThat((Object)key2.schema()).isSameAs((Object)tombstone.keySchema());
        Assertions.assertThat((Object)key2.get("_id")).isEqualTo((Object)objId.toString());
        Assertions.assertThat((Object)tombstone.value()).isNull();
        Assertions.assertThat((Object)tombstone.valueSchema()).isNull();
    }
}

