/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.CursorType;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.connector.mongodb.AbstractMongoIT;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.util.Testing;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ConnectionIT
extends AbstractMongoIT {
    @Test
    public void shouldCreateMovieDatabase() {
        Testing.print((Object)("Configuration: " + this.config));
        String dbName = "dbA";
        this.primary.execute("shouldCreateMovieDatabase", mongo -> {
            Testing.debug((Object)"Getting or creating 'movies' collection");
            MongoDatabase db = mongo.getDatabase(dbName);
            db.getCollection("movies");
            Testing.debug((Object)"Completed getting 'movies' collection");
        });
        this.primary.execute("Add document to movies collection", mongo -> {
            Testing.debug((Object)"Adding document to 'movies' collection");
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection movies = db.getCollection("movies");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            movies.insertOne((Object)Document.parse((String)"{ \"name\":\"Starter Wars\"}"), insertOptions);
            Assertions.assertThat((long)db.getCollection("movies").count()).isEqualTo(1L);
            Bson filter = Filters.eq((String)"name", (Object)"Starter Wars");
            FindIterable movieResults = db.getCollection("movies").find(filter);
            try (MongoCursor cursor = movieResults.iterator();){
                Assertions.assertThat((String)((Document)cursor.tryNext()).getString((Object)"name")).isEqualTo((Object)"Starter Wars");
                Assertions.assertThat((Map)((Map)cursor.tryNext())).isNull();
            }
            Testing.debug((Object)"Completed document to 'movies' collection");
        });
        Assertions.assertThat((Collection)this.primary.databaseNames()).contains(new Object[]{"dbA"});
        Assertions.assertThat((List)this.primary.collections()).contains(new Object[]{new CollectionId(this.replicaSet.replicaSetName(), dbName, "movies")});
        LinkedList eventQueue = new LinkedList();
        int minimumEventsExpected = 1;
        long maxSeconds = 5L;
        this.primary.execute("read oplog from beginning", mongo -> {
            Testing.debug((Object)"Getting local.oplog.rs");
            BsonTimestamp oplogStart = new BsonTimestamp(1, 1);
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.gt((String)"ts", (Object)oplogStart), Filters.exists((String)"fromMigrate", (boolean)false)});
            FindIterable results = mongo.getDatabase("local").getCollection("oplog.rs").find(filter).sort((Bson)new Document("$natural", (Object)1)).oplogReplay(true).noCursorTimeout(true).cursorType(CursorType.TailableAwait);
            Testing.debug((Object)"Reading local.oplog.rs");
            try (MongoCursor cursor = results.iterator();){
                Document event = null;
                long stopTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
                while (System.currentTimeMillis() < stopTime && eventQueue.size() < minimumEventsExpected) {
                    while ((event = (Document)cursor.tryNext()) != null) {
                        eventQueue.add(event);
                    }
                }
                Assertions.assertThat((int)eventQueue.size()).isGreaterThanOrEqualTo(1);
            }
            Testing.debug((Object)"Completed local.oplog.rs");
        });
        eventQueue.forEach(event -> {
            Testing.print((Object)("Found: " + event));
            BsonTimestamp position = (BsonTimestamp)event.get((Object)"ts", BsonTimestamp.class);
            assert (position != null);
        });
    }

    @Test
    public void shouldListDatabases() {
        Testing.Print.enable();
        Testing.print((Object)("Databases: " + this.primary.databaseNames()));
    }
}

