/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadConcernLevel;
import com.mongodb.assertions.Assertions;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public final class ReadConcern {
    private final ReadConcernLevel readConcernLevel;
    public static final ReadConcern DEFAULT = new ReadConcern();
    public static final ReadConcern LOCAL = new ReadConcern(ReadConcernLevel.LOCAL);
    public static final ReadConcern MAJORITY = new ReadConcern(ReadConcernLevel.MAJORITY);
    public static final ReadConcern LINEARIZABLE = new ReadConcern(ReadConcernLevel.LINEARIZABLE);

    public ReadConcern(ReadConcernLevel readConcernLevel) {
        this.readConcernLevel = Assertions.notNull("readConcernLevel", readConcernLevel);
    }

    public boolean isServerDefault() {
        return this.readConcernLevel == null;
    }

    public BsonDocument asDocument() {
        BsonDocument readConcern = new BsonDocument();
        if (!this.isServerDefault()) {
            readConcern.put("level", (BsonValue)new BsonString(this.readConcernLevel.getValue()));
        }
        return readConcern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ReadConcern that = (ReadConcern)o;
        return this.readConcernLevel == that.readConcernLevel;
    }

    public int hashCode() {
        return this.readConcernLevel != null ? this.readConcernLevel.hashCode() : 0;
    }

    private ReadConcern() {
        this.readConcernLevel = null;
    }
}

