/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@ThreadSafe
public class MongoClients {
    private final Map<ServerAddress, MongoClient> directConnections = new ConcurrentHashMap<ServerAddress, MongoClient>();
    private final Map<List<ServerAddress>, MongoClient> connections = new ConcurrentHashMap<List<ServerAddress>, MongoClient>();
    private final List<MongoCredential> credentials = new CopyOnWriteArrayList<MongoCredential>();
    private final MongoClientOptions options;

    public static Builder create() {
        return new Builder();
    }

    private MongoClients(MongoClientOptions options, List<MongoCredential> credentials) {
        this.options = options;
        if (credentials != null) {
            credentials.forEach(this.credentials::add);
        }
    }

    public void clear() {
        this.directConnections.values().forEach(Mongo::close);
        this.connections.values().forEach(Mongo::close);
        this.directConnections.clear();
        this.connections.clear();
    }

    public MongoClient clientFor(String addressString) {
        return this.clientFor(MongoUtil.parseAddress(addressString));
    }

    public MongoClient clientFor(ServerAddress address) {
        return this.directConnections.computeIfAbsent(address, this::directConnection);
    }

    public MongoClient clientForMembers(String addressList) {
        return this.clientForMembers(MongoUtil.parseAddresses(addressList));
    }

    public MongoClient clientForMembers(ServerAddress ... seeds) {
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        for (ServerAddress seedAddress : seeds) {
            if (seedAddress == null) continue;
            addresses.add(seedAddress);
        }
        return this.clientForMembers(addresses);
    }

    public MongoClient clientForMembers(List<ServerAddress> seedAddresses) {
        return this.connections.computeIfAbsent(seedAddresses, this::connection);
    }

    protected MongoClient directConnection(ServerAddress address) {
        return new MongoClient(address, this.credentials, this.options);
    }

    protected MongoClient connection(List<ServerAddress> addresses) {
        return new MongoClient(addresses, this.credentials, this.options);
    }

    public static class Builder {
        private final List<MongoCredential> credentials = new CopyOnWriteArrayList<MongoCredential>();
        private final MongoClientOptions.Builder optionBuilder = MongoClientOptions.builder();

        public Builder withCredential(MongoCredential credential) {
            if (credential != null) {
                this.credentials.add(credential);
            }
            return this;
        }

        public MongoClientOptions.Builder options() {
            return this.optionBuilder;
        }

        public MongoClients build() {
            return new MongoClients(this.optionBuilder.build(), this.credentials);
        }
    }
}

