/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import io.debezium.util.Strings;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class Predicates {
    public static Predicate<String> includes(String regexPatterns) {
        return Predicates.includes(regexPatterns, str -> str);
    }

    public static Predicate<String> excludes(String regexPatterns) {
        return Predicates.includes(regexPatterns).negate();
    }

    public static <T> Predicate<T> includes(String regexPatterns, Function<T, String> conversion) {
        Set<Pattern> patterns = Strings.listOfRegex(regexPatterns, 2);
        return t -> {
            String str = (String)conversion.apply(t);
            if (str != null) {
                for (Pattern p : patterns) {
                    if (!p.matcher(str).matches()) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static <T> Predicate<T> excludes(String regexPatterns, Function<T, String> conversion) {
        return Predicates.includes(regexPatterns, conversion).negate();
    }

    public static <T> Predicate<T> filter(Predicate<T> allowed, Predicate<T> disallowed) {
        return allowed != null ? allowed : (disallowed != null ? disallowed : id -> true);
    }

    public static <R> Predicate<R> not(Predicate<R> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> notNull() {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return t != null;
            }
        };
    }

    private Predicates() {
    }
}

