/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.TopicSelector;
import org.fest.assertions.Assertions;
import org.fest.assertions.StringAssert;
import org.junit.Before;
import org.junit.Test;

public class TopicSelectorTest {
    private TopicSelector noPrefix;
    private TopicSelector withPrefix;

    @Before
    public void beforeEach() {
        this.noPrefix = TopicSelector.defaultSelector(null);
        this.withPrefix = TopicSelector.defaultSelector((String)"prefix");
    }

    @Test
    public void shouldHandleCollectionIdWithDatabaseAndCollection() {
        this.assertTopic(this.noPrefix, this.dbAndCollection("db", "coll")).isEqualTo((Object)"db.coll");
        this.assertTopic(this.withPrefix, this.dbAndCollection("db", "coll")).isEqualTo((Object)"prefix.db.coll");
    }

    protected StringAssert assertTopic(TopicSelector selector, CollectionId collectionId) {
        return Assertions.assertThat((String)selector.getTopic(collectionId));
    }

    protected CollectionId dbAndCollection(String dbName, String collectionName) {
        return new CollectionId("rs0", dbName, collectionName);
    }
}

