/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.FindIterableImpl;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AggregateIterableImpl<TDocument, TResult>
implements AggregateIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final List<? extends Bson> pipeline;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private long maxTimeMS;
    private Boolean useCursor;
    private Boolean bypassDocumentValidation;

    AggregateIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<TResult> execute() {
        BsonValue outCollection;
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue bsonValue = outCollection = aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get((Object)"$out");
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).bypassDocumentValidation(this.bypassDocumentValidation);
            this.executor.execute((WriteOperation)operation);
            FindIterableImpl<TDocument, TResult> findOperation = new FindIterableImpl<TDocument, TResult>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), this.documentClass, this.resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, (Bson)new BsonDocument(), new FindOptions());
            if (this.batchSize != null) {
                findOperation.batchSize(this.batchSize);
            }
            return findOperation;
        }
        return new OperationIterable(new AggregateOperation(this.namespace, aggregateList, (Decoder)this.codecRegistry.get(this.resultClass)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize).useCursor(this.useCursor).readConcern(this.readConcern), this.readPreference, this.executor);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            aggregateList.add(bson.toBsonDocument(this.documentClass, this.codecRegistry));
        }
        return aggregateList;
    }
}

