/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.TopicSelector;
import io.debezium.util.Clock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationContext
extends ConnectionContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Filters filters;
    private final SourceInfo source;
    private final Clock clock = Clock.system();
    private final TopicSelector topicSelector;

    public ReplicationContext(Configuration config) {
        super(config);
        String serverName = config.getString(MongoDbConnectorConfig.LOGICAL_NAME);
        this.filters = new Filters(config);
        this.source = new SourceInfo(serverName);
        this.topicSelector = TopicSelector.defaultSelector(serverName);
    }

    @Override
    protected Logger logger() {
        return this.logger;
    }

    public TopicSelector topicSelector() {
        return this.topicSelector;
    }

    public Predicate<CollectionId> collectionFilter() {
        return this.filters.collectionFilter();
    }

    public SourceInfo source() {
        return this.source;
    }

    public Clock clock() {
        return this.clock;
    }
}

