/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.ReplicaSetStatus;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.ReplicationContext;
import io.debezium.function.BlockingConsumer;
import io.debezium.util.Strings;
import java.util.HashSet;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReplicaSetDiscovery {
    public static final String CONFIG_DATABASE_NAME = "config";
    public static final String ADMIN_DATABASE_NAME = "admin";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReplicationContext context;
    private final String seedAddresses;

    public ReplicaSetDiscovery(ReplicationContext context) {
        this.context = context;
        this.seedAddresses = context.hosts();
    }

    public ReplicaSets getReplicaSets() {
        MongoClient client = this.context.clientFor(this.seedAddresses);
        HashSet<ReplicaSet> replicaSetSpecs = new HashSet<ReplicaSet>();
        MongoUtil.onCollectionDocuments(client, CONFIG_DATABASE_NAME, "shards", (BlockingConsumer<Document>)((BlockingConsumer)doc -> {
            this.logger.info("Checking shard details from configuration replica set {}", (Object)this.seedAddresses);
            String shardName = doc.getString((Object)"_id");
            String hostStr = doc.getString((Object)"host");
            String replicaSetName = MongoUtil.replicaSetUsedIn(hostStr);
            replicaSetSpecs.add(new ReplicaSet(hostStr, replicaSetName, shardName));
        }));
        if (replicaSetSpecs.isEmpty()) {
            ReplicaSetStatus rsStatus = client.getReplicaSetStatus();
            this.logger.info("Checking current members of replica set at {}", (Object)this.seedAddresses);
            if (rsStatus != null) {
                String addressStr = Strings.join((CharSequence)",", (Iterable)client.getServerAddressList());
                String replicaSetName = rsStatus.getName();
                replicaSetSpecs.add(new ReplicaSet(addressStr, replicaSetName, null));
            } else {
                this.logger.debug("Found standalone MongoDB replica set at {}", (Object)this.seedAddresses);
                String replicaSetName = MongoUtil.replicaSetUsedIn(this.seedAddresses);
                for (String address : this.seedAddresses.split(",")) {
                    replicaSetSpecs.add(new ReplicaSet(address, replicaSetName, null));
                }
            }
        }
        return new ReplicaSets(replicaSetSpecs);
    }
}

