/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.util.AvroValidator;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.BsonTimestamp;
import org.bson.Document;

@NotThreadSafe
public final class SourceInfo {
    public static final int SCHEMA_VERSION = 1;
    public static final String SERVER_ID_KEY = "server_id";
    public static final String SERVER_NAME = "name";
    public static final String REPLICA_SET_NAME = "rs";
    public static final String NAMESPACE = "ns";
    public static final String TIMESTAMP = "sec";
    public static final String ORDER = "ord";
    public static final String OPERATION_ID = "h";
    public static final String INITIAL_SYNC = "initsync";
    private static final BsonTimestamp INITIAL_TIMESTAMP = new BsonTimestamp();
    private static final Position INITIAL_POSITION = new Position(INITIAL_TIMESTAMP, null);
    private final Schema SOURCE_SCHEMA = SchemaBuilder.struct().name(AvroValidator.defaultValidator().validate("io.debezium.connector.mongo.Source")).version(Integer.valueOf(1)).field("name", Schema.STRING_SCHEMA).field("rs", Schema.STRING_SCHEMA).field("ns", Schema.STRING_SCHEMA).field("sec", Schema.INT32_SCHEMA).field("ord", Schema.INT32_SCHEMA).field("h", Schema.OPTIONAL_INT64_SCHEMA).field("initsync", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    private final ConcurrentMap<String, Map<String, String>> sourcePartitionsByReplicaSetName = new ConcurrentHashMap<String, Map<String, String>>();
    private final ConcurrentMap<String, Position> positionsByReplicaSetName = new ConcurrentHashMap<String, Position>();
    private final Set<String> initialSyncReplicaSets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String serverName;

    public SourceInfo(String serverName) {
        this.serverName = serverName;
        assert (this.serverName != null);
    }

    public Schema schema() {
        return this.SOURCE_SCHEMA;
    }

    public Map<String, String> partition(String replicaSetName) {
        return this.sourcePartitionsByReplicaSetName.computeIfAbsent(replicaSetName, rsName -> Collect.hashMapOf((Object)SERVER_ID_KEY, (Object)this.serverName, (Object)REPLICA_SET_NAME, (Object)rsName));
    }

    public BsonTimestamp lastOffsetTimestamp(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        return existing != null ? existing.ts : INITIAL_TIMESTAMP;
    }

    public Map<String, ?> lastOffset(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        if (existing == null) {
            existing = INITIAL_POSITION;
        }
        if (this.initialSyncReplicaSets.contains(replicaSetName)) {
            return Collect.hashMapOf((Object)TIMESTAMP, (Object)new Integer(existing.getTime()), (Object)ORDER, (Object)new Integer(existing.getInc()), (Object)OPERATION_ID, (Object)existing.getOperationId(), (Object)INITIAL_SYNC, (Object)true);
        }
        return Collect.hashMapOf((Object)TIMESTAMP, (Object)new Integer(existing.getTime()), (Object)ORDER, (Object)new Integer(existing.getInc()), (Object)OPERATION_ID, (Object)existing.getOperationId());
    }

    public Struct lastOffsetStruct(String replicaSetName, CollectionId collectionId) {
        return this.offsetStructFor(replicaSetName, collectionId.namespace(), (Position)this.positionsByReplicaSetName.get(replicaSetName), this.initialSyncReplicaSets.contains(replicaSetName));
    }

    public Struct offsetStructForEvent(String replicaSetName, Document oplogEvent) {
        Position position = INITIAL_POSITION;
        String namespace = "";
        if (oplogEvent != null) {
            BsonTimestamp ts = SourceInfo.extractEventTimestamp(oplogEvent);
            Long opId = oplogEvent.getLong((Object)OPERATION_ID);
            position = new Position(ts, opId);
            namespace = oplogEvent.getString((Object)NAMESPACE);
        }
        this.positionsByReplicaSetName.put(replicaSetName, position);
        return this.offsetStructFor(replicaSetName, namespace, position, this.initialSyncReplicaSets.contains(replicaSetName));
    }

    protected static BsonTimestamp extractEventTimestamp(Document oplogEvent) {
        return oplogEvent != null ? (BsonTimestamp)oplogEvent.get((Object)"ts", BsonTimestamp.class) : null;
    }

    private Struct offsetStructFor(String replicaSetName, String namespace, Position position, boolean isInitialSync) {
        if (position == null) {
            position = INITIAL_POSITION;
        }
        Struct result = new Struct(this.SOURCE_SCHEMA);
        result.put(SERVER_NAME, (Object)this.serverName);
        result.put(REPLICA_SET_NAME, (Object)replicaSetName);
        result.put(NAMESPACE, (Object)namespace);
        result.put(TIMESTAMP, (Object)position.getTime());
        result.put(ORDER, (Object)position.getInc());
        result.put(OPERATION_ID, (Object)position.getOperationId());
        if (isInitialSync) {
            result.put(INITIAL_SYNC, (Object)true);
        }
        return result;
    }

    public boolean hasOffset(String replicaSetName) {
        return this.positionsByReplicaSetName.containsKey(replicaSetName);
    }

    public boolean setOffsetFor(String replicaSetName, Map<String, ?> sourceOffset) {
        if (replicaSetName == null) {
            throw new IllegalArgumentException("The replica set name may not be null");
        }
        if (sourceOffset == null) {
            return false;
        }
        int time = SourceInfo.intOffsetValue(sourceOffset, TIMESTAMP);
        int order = SourceInfo.intOffsetValue(sourceOffset, ORDER);
        Long operationId = SourceInfo.longOffsetValue(sourceOffset, OPERATION_ID);
        this.positionsByReplicaSetName.put(replicaSetName, new Position(time, order, operationId));
        return true;
    }

    public boolean setOffsetFor(Map<String, String> partition, Map<String, ?> sourceOffset) {
        String replicaSetName = partition.get(REPLICA_SET_NAME);
        return this.setOffsetFor(replicaSetName, sourceOffset);
    }

    public void startInitialSync(String replicaSetName) {
        this.initialSyncReplicaSets.add(replicaSetName);
    }

    public void stopInitialSync(String replicaSetName) {
        this.initialSyncReplicaSets.remove(replicaSetName);
    }

    private static int intOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to an integer");
        }
    }

    private static long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    @Immutable
    protected static final class Position {
        private final Long opId;
        private final BsonTimestamp ts;

        public Position(int ts, int order, Long opId) {
            this(new BsonTimestamp(ts, order), opId);
        }

        public Position(BsonTimestamp ts, Long opId) {
            this.ts = ts;
            this.opId = opId;
            assert (this.ts != null);
        }

        public BsonTimestamp getTimestamp() {
            return this.ts;
        }

        public int getTime() {
            return this.ts.getTime();
        }

        public int getInc() {
            return this.ts.getInc();
        }

        public Long getOperationId() {
            return this.opId;
        }
    }
}

