/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.ReplicationContext;
import io.debezium.connector.mongodb.Replicator;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MongoDbConnectorTask
extends SourceTask {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Deque<Replicator> replicators = new ConcurrentLinkedDeque<Replicator>();
    private volatile TaskRecordQueue queue;
    private volatile String taskName;
    private volatile ReplicationContext replContext;

    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map<String, String> props) {
        ReplicationContext replicationContext;
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (this.context == null) {
            throw new ConnectException("Unexpected null context");
        }
        Configuration config = Configuration.from(props);
        this.taskName = "task" + config.getInteger(MongoDbConnectorConfig.TASK_ID);
        this.replContext = replicationContext = new ReplicationContext(config);
        LoggingContext.PreviousContext previousLogContext = replicationContext.configureLoggingContext(this.taskName);
        try {
            this.logger.info("Starting MongoDB connector task with configuration:");
            config.forEach((propName, propValue) -> this.logger.info("   {} = {}", propName, propValue));
            if (!config.validateAndRecord((Iterable)MongoDbConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)this.logger).error(arg_0))) {
                throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
            }
            String hosts = config.getString(MongoDbConnectorConfig.HOSTS);
            ReplicaSets replicaSets = ReplicaSets.parse(hosts);
            this.queue = new TaskRecordQueue(config, replicaSets.replicaSetCount(), this.running::get);
            SourceInfo source = replicationContext.source();
            ArrayList partitions = new ArrayList();
            replicaSets.onEachReplicaSet(replicaSet -> {
                String replicaSetName = replicaSet.replicaSetName();
                partitions.add(source.partition(replicaSetName));
            });
            this.context.offsetStorageReader().offsets(partitions).forEach(source::setOffsetFor);
            int numThreads = replicaSets.replicaSetCount();
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            AtomicInteger stillRunning = new AtomicInteger(numThreads);
            this.logger.info("Starting {} thread(s) to replicate replica sets: {}", (Object)numThreads, (Object)replicaSets);
            replicaSets.all().forEach(replicaSet -> {
                Replicator replicator = new Replicator(replicationContext, (ReplicaSet)replicaSet, (BlockingConsumer<SourceRecord>)((BlockingConsumer)this.queue::enqueue));
                this.replicators.add(replicator);
                executor.submit(() -> {
                    try {
                        replicationContext.configureLoggingContext(replicaSet.replicaSetName());
                        replicator.run();
                    }
                    finally {
                        try {
                            this.replicators.remove(replicator);
                        }
                        finally {
                            if (stillRunning.decrementAndGet() == 0) {
                                try {
                                    executor.shutdown();
                                }
                                finally {
                                    replicationContext.shutdown();
                                }
                            }
                        }
                    }
                });
            });
            this.logger.info("Successfully started MongoDB connector task with {} thread(s) for replica sets {}", (Object)numThreads, (Object)replicaSets);
        }
        finally {
            previousLogContext.restore();
        }
    }

    public List<SourceRecord> poll() throws InterruptedException {
        return this.queue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LoggingContext.PreviousContext previousLogContext = this.replContext.configureLoggingContext(this.taskName);
        try {
            if (this.running.compareAndSet(true, false)) {
                this.logger.info("Stopping MongoDB task");
                Replicator replicator = null;
                int counter = 0;
                while ((replicator = this.replicators.poll()) != null) {
                    replicator.stop();
                    ++counter;
                }
                this.logger.info("Stopped MongoDB replication task by stopping {} replicator threads", (Object)counter);
            }
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error shutting down the MongoDB replication task", e);
        }
        finally {
            previousLogContext.restore();
        }
    }

    @Immutable
    protected static class TaskRecordQueue {
        private final int maxBatchSize;
        private final Metronome metronome;
        private final BlockingQueue<SourceRecord> records;
        private final BooleanSupplier isRunning;

        protected TaskRecordQueue(Configuration config, int numThreads, BooleanSupplier isRunning) {
            int maxQueueSize = config.getInteger(MongoDbConnectorConfig.MAX_QUEUE_SIZE);
            long pollIntervalMs = config.getLong(MongoDbConnectorConfig.POLL_INTERVAL_MS);
            this.maxBatchSize = config.getInteger(MongoDbConnectorConfig.MAX_BATCH_SIZE);
            this.metronome = Metronome.parker((long)pollIntervalMs, (TimeUnit)TimeUnit.MILLISECONDS, (Clock)Clock.SYSTEM);
            this.records = new LinkedBlockingDeque<SourceRecord>(maxQueueSize);
            this.isRunning = isRunning;
        }

        public List<SourceRecord> poll() throws InterruptedException {
            ArrayList<SourceRecord> batch = new ArrayList<SourceRecord>(this.maxBatchSize);
            while (this.isRunning.getAsBoolean() && this.records.drainTo(batch, this.maxBatchSize) == 0) {
                this.metronome.pause();
            }
            return batch;
        }

        public void enqueue(SourceRecord record) throws InterruptedException {
            if (record != null) {
                this.records.put(record);
            }
        }
    }
}

