/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ServerAddress;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.ArrayList;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MongoUtilTest {
    private ServerAddress address;
    private List<ServerAddress> addresses = new ArrayList<ServerAddress>();

    @Test
    public void shouldParseIPv4ServerAddressWithoutPort() {
        this.address = MongoUtil.parseAddress((String)"localhost");
        Assertions.assertThat((String)this.address.getHost()).isEqualTo((Object)"localhost");
        Assertions.assertThat((int)this.address.getPort()).isEqualTo(ServerAddress.defaultPort());
    }

    @Test
    public void shouldParseIPv4ServerAddressWithoPort() {
        this.address = MongoUtil.parseAddress((String)"localhost:28017");
        Assertions.assertThat((String)this.address.getHost()).isEqualTo((Object)"localhost");
        Assertions.assertThat((int)this.address.getPort()).isEqualTo(28017);
    }

    @Test
    public void shouldParseIPv6ServerAddressWithoutPort() {
        this.address = MongoUtil.parseAddress((String)"[::1/128]");
        Assertions.assertThat((String)this.address.getHost()).isEqualTo((Object)"::1/128");
        Assertions.assertThat((int)this.address.getPort()).isEqualTo(ServerAddress.defaultPort());
    }

    @Test
    public void shouldParseIPv6ServerAddressWithPort() {
        this.address = MongoUtil.parseAddress((String)"[::1/128]:28017");
        Assertions.assertThat((String)this.address.getHost()).isEqualTo((Object)"::1/128");
        Assertions.assertThat((int)this.address.getPort()).isEqualTo(28017);
    }

    @Test
    public void shouldParseServerAddressesWithoutPort() {
        this.addresses = MongoUtil.parseAddresses((String)"host1,host2,[::1/128],host4");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(4);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)"host1");
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(1).getHost()).isEqualTo((Object)"host2");
        Assertions.assertThat((int)this.addresses.get(1).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(2).getHost()).isEqualTo((Object)"::1/128");
        Assertions.assertThat((int)this.addresses.get(2).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(3).getHost()).isEqualTo((Object)"host4");
        Assertions.assertThat((int)this.addresses.get(3).getPort()).isEqualTo(ServerAddress.defaultPort());
    }

    @Test
    public void shouldParseServerAddressesWithPort() {
        this.addresses = MongoUtil.parseAddresses((String)"host1:2111,host2:3111,[ff02::2:ff00:0/104]:4111,host4:5111");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(4);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)"host1");
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(2111);
        Assertions.assertThat((String)this.addresses.get(1).getHost()).isEqualTo((Object)"host2");
        Assertions.assertThat((int)this.addresses.get(1).getPort()).isEqualTo(3111);
        Assertions.assertThat((String)this.addresses.get(2).getHost()).isEqualTo((Object)"ff02::2:ff00:0/104");
        Assertions.assertThat((int)this.addresses.get(2).getPort()).isEqualTo(4111);
        Assertions.assertThat((String)this.addresses.get(3).getHost()).isEqualTo((Object)"host4");
        Assertions.assertThat((int)this.addresses.get(3).getPort()).isEqualTo(5111);
    }

    @Test
    public void shouldParseServerAddressesWithReplicaSetNameAndWithoutPort() {
        this.addresses = MongoUtil.parseAddresses((String)"replicaSetName/host1,host2,[::1/128],host4");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(4);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)"host1");
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(1).getHost()).isEqualTo((Object)"host2");
        Assertions.assertThat((int)this.addresses.get(1).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(2).getHost()).isEqualTo((Object)"::1/128");
        Assertions.assertThat((int)this.addresses.get(2).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(3).getHost()).isEqualTo((Object)"host4");
        Assertions.assertThat((int)this.addresses.get(3).getPort()).isEqualTo(ServerAddress.defaultPort());
    }

    @Test
    public void shouldParseServerAddressesWithReplicaSetNameAndWithPort() {
        this.addresses = MongoUtil.parseAddresses((String)"replicaSetName/host1:2111,host2:3111,[ff02::2:ff00:0/104]:4111,host4:5111");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(4);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)"host1");
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(2111);
        Assertions.assertThat((String)this.addresses.get(1).getHost()).isEqualTo((Object)"host2");
        Assertions.assertThat((int)this.addresses.get(1).getPort()).isEqualTo(3111);
        Assertions.assertThat((String)this.addresses.get(2).getHost()).isEqualTo((Object)"ff02::2:ff00:0/104");
        Assertions.assertThat((int)this.addresses.get(2).getPort()).isEqualTo(4111);
        Assertions.assertThat((String)this.addresses.get(3).getHost()).isEqualTo((Object)"host4");
        Assertions.assertThat((int)this.addresses.get(3).getPort()).isEqualTo(5111);
    }

    @Test
    public void shouldParseServerIPv6AddressesWithReplicaSetNameAndWithoutPort() {
        this.addresses = MongoUtil.parseAddresses((String)"replicaSetName/[::1/128],host2,[ff02::2:ff00:0/104],host4");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(4);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)"::1/128");
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(1).getHost()).isEqualTo((Object)"host2");
        Assertions.assertThat((int)this.addresses.get(1).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(2).getHost()).isEqualTo((Object)"ff02::2:ff00:0/104");
        Assertions.assertThat((int)this.addresses.get(2).getPort()).isEqualTo(ServerAddress.defaultPort());
        Assertions.assertThat((String)this.addresses.get(3).getHost()).isEqualTo((Object)"host4");
        Assertions.assertThat((int)this.addresses.get(3).getPort()).isEqualTo(ServerAddress.defaultPort());
    }

    @Test
    public void shouldParseServerIPv6AddressesWithReplicaSetNameAndWithPort() {
        this.addresses = MongoUtil.parseAddresses((String)"replicaSetName/[::1/128]:2111,host2:3111,[ff02::2:ff00:0/104]:4111,host4:5111");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(4);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)"::1/128");
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(2111);
        Assertions.assertThat((String)this.addresses.get(1).getHost()).isEqualTo((Object)"host2");
        Assertions.assertThat((int)this.addresses.get(1).getPort()).isEqualTo(3111);
        Assertions.assertThat((String)this.addresses.get(2).getHost()).isEqualTo((Object)"ff02::2:ff00:0/104");
        Assertions.assertThat((int)this.addresses.get(2).getPort()).isEqualTo(4111);
        Assertions.assertThat((String)this.addresses.get(3).getHost()).isEqualTo((Object)"host4");
        Assertions.assertThat((int)this.addresses.get(3).getPort()).isEqualTo(5111);
    }

    @Test
    public void shouldNotParseServerAddressesWithReplicaSetNameAndOpenBracket() {
        this.addresses = MongoUtil.parseAddresses((String)"replicaSetName/[");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(0);
    }

    @Test
    public void shouldNotParseServerAddressesWithReplicaSetNameAndNoAddress() {
        this.addresses = MongoUtil.parseAddresses((String)"replicaSetName/");
        Assertions.assertThat((int)this.addresses.size()).isEqualTo(1);
        Assertions.assertThat((String)this.addresses.get(0).getHost()).isEqualTo((Object)ServerAddress.defaultHost());
        Assertions.assertThat((int)this.addresses.get(0).getPort()).isEqualTo(ServerAddress.defaultPort());
    }

    @Test
    public void shouldParseReplicaSetName() {
        Assertions.assertThat((String)MongoUtil.replicaSetUsedIn((String)"rs0/")).isEqualTo((Object)"rs0");
        Assertions.assertThat((String)MongoUtil.replicaSetUsedIn((String)"rs0/localhost")).isEqualTo((Object)"rs0");
        Assertions.assertThat((String)MongoUtil.replicaSetUsedIn((String)"rs0/[::1/128]")).isEqualTo((Object)"rs0");
    }

    @Test
    public void shouldNotParseReplicaSetName() {
        Assertions.assertThat((String)MongoUtil.replicaSetUsedIn((String)"")).isNull();
        Assertions.assertThat((String)MongoUtil.replicaSetUsedIn((String)"localhost")).isNull();
        Assertions.assertThat((String)MongoUtil.replicaSetUsedIn((String)"[::1/128]")).isNull();
    }
}

