/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Configurator;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTopicSelector;
import io.debezium.connector.mongodb.RecordMakers;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.schema.TopicSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FieldBlacklistTest {
    private static final String SERVER_NAME = "serverX";
    private static final String PATCH = "patch";
    private static final JsonWriterSettings WRITER_SETTINGS = new JsonWriterSettings(JsonMode.STRICT, "", "");
    private Configurator build;
    private SourceInfo source;
    private TopicSelector<CollectionId> topicSelector;

    @Before
    public void setup() {
        this.build = new Configurator();
        this.source = new SourceInfo(new MongoDbConnectorConfig(((Configuration.Builder)Configuration.create().with(MongoDbConnectorConfig.LOGICAL_NAME, SERVER_NAME)).build()));
        this.topicSelector = MongoDbTopicSelector.defaultSelector((String)SERVER_NAME, (String)"__debezium-heartbeat");
    }

    @Test
    public void shouldNotExcludeFieldsForEventOfOtherCollection() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c2.name,*.c2.active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active,*.c1.address.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.address.missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active,*.c1.address.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.address.missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active,*.c1.address.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.address.missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}],\"active\": true,\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedFieldsForUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"active\": true,\"scores\": [1.2,3.4,5.6]}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeFieldsForSetTopLevelFieldUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L));
        Filters filters = this.build.excludeFields("*.c1.name").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"phone\": {\"$numberLong\": \"123\"}}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeFieldsForUnsetTopLevelFieldUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("phone", (Object)""));
        Filters filters = this.build.excludeFields("*.c1.name").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\": {\"phone\": \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.address.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]]}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("address.number", (Object)34L).append("address.street", (Object)"Claude Debussylaan").append("address.city", (Object)"Amsterdam"));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.address.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"address.street\": \"Claude Debussylaan\",\"address.city\": \"Amsterdam\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.excludeFields("*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"name\": \"Sally\",\"addresses.0.street\": \"Claude Debussylaan\",\"addresses.0.city\": \"Amsterdam\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedFieldsForSetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.excludeFields("*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.second.0.number", (Object)34L).append("addresses.0.second.0.street", (Object)"Claude Debussylaan").append("addresses.0.second.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.excludeFields("*.c1.addresses.second.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"name\": \"Sally\",\"addresses.0.second.0.street\": \"Claude Debussylaan\",\"addresses.0.second.0.city\": \"Amsterdam\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.excludeFields("*.c1.addresses").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"name\": \"Sally\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeFieldsForSetToArrayFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        Filters filters = this.build.excludeFields("*.c1.addresses").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\": {\"name\": \"Sally\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("address.number", (Object)"").append("address.street", (Object)"").append("address.city", (Object)""));
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.address.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\": {\"address.street\": \"\",\"address.city\": \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        Filters filters = this.build.excludeFields("*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\": {\"name\": \"\",\"addresses.0.street\": \"\",\"addresses.0.city\": \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.0.number", (Object)"").append("addresses.0.0.street", (Object)"").append("addresses.0.0.city", (Object)""));
        Filters filters = this.build.excludeFields("*.c1.addresses.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.second.0.number", (Object)"").append("addresses.0.second.0.street", (Object)"").append("addresses.0.second.0.city", (Object)""));
        Filters filters = this.build.excludeFields("*.c1.addresses.second.number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\": {\"name\": \"\",\"addresses.0.second.0.street\": \"\",\"addresses.0.second.0.city\": \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        Filters filters = this.build.excludeFields("*.c1.addresses").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\": {\"name\": \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldExcludeFieldsForDeleteEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "d"), 1002L);
        Struct value = this.getValue(produced);
        String json = value.getString("after");
        if (json == null) {
            json = value.getString(PATCH);
        }
        Assertions.assertThat((String)json).isNull();
    }

    @Test
    public void shouldExcludeFieldsForDeleteTombstoneEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Filters filters = this.build.excludeFields("*.c1.name,*.c1.active").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "d"), 1002L);
        SourceRecord record = (SourceRecord)produced.get(1);
        Assertions.assertThat((Object)record.value()).isNull();
    }

    private Struct getValue(List<SourceRecord> produced) {
        SourceRecord record = produced.get(0);
        return (Struct)record.value();
    }

    private Document createEvent(Document obj, String op) {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        return new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)op);
    }

    private Document createUpdateEvent(Document obj, ObjectId objId) {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        return new Document().append("o", (Object)obj).append("o2", (Object)objId).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"u");
    }
}

