/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ReadBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.client.model.CountStrategy;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.ExplainHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.OperationReadConcernHelper;
import com.mongodb.operation.ReadOperation;
import com.mongodb.session.SessionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

@Deprecated
public class CountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private final CountStrategy countStrategy;
    private BsonDocument filter;
    private BsonValue hint;
    private long skip;
    private long limit;
    private long maxTimeMS;
    private Collation collation;

    public CountOperation(MongoNamespace namespace) {
        this(namespace, CountStrategy.COMMAND);
    }

    public CountOperation(MongoNamespace namespace, CountStrategy countStrategy) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.countStrategy = Assertions.notNull("countStrategy", countStrategy);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountOperation filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public CountOperation hint(BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CountOperation collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Long execute(final ReadBinding binding) {
        if (this.countStrategy.equals((Object)CountStrategy.COMMAND)) {
            return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Long>(){

                @Override
                public Long call(Connection connection) {
                    OperationHelper.validateReadConcernAndCollation(connection, binding.getSessionContext().getReadConcern(), CountOperation.this.collation);
                    return (Long)CommandOperationHelper.executeWrappedCommandProtocol(binding, CountOperation.this.namespace.getDatabaseName(), CountOperation.this.getCommand(binding.getSessionContext()), (Decoder<BsonDocument>)DECODER, connection, CountOperation.this.transformer());
                }
            });
        }
        Object cursor = this.getAggregateOperation().execute(binding);
        return cursor.hasNext() ? this.getCountFromAggregateResults(cursor.next()) : 0L;
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<Long> callback) {
        if (this.countStrategy.equals((Object)CountStrategy.COMMAND)) {
            OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

                @Override
                public void call(AsyncConnection connection, Throwable t) {
                    SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                    if (t != null) {
                        errHandlingCallback.onResult(null, t);
                    } else {
                        final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                        OperationHelper.validateReadConcernAndCollation(connection, binding.getSessionContext().getReadConcern(), CountOperation.this.collation, new OperationHelper.AsyncCallableWithConnection(){

                            @Override
                            public void call(AsyncConnection connection, Throwable t) {
                                if (t != null) {
                                    wrappedCallback.onResult(null, t);
                                } else {
                                    CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, CountOperation.this.namespace.getDatabaseName(), CountOperation.this.getCommand(binding.getSessionContext()), (Decoder<BsonDocument>)DECODER, connection, CountOperation.this.transformer(), wrappedCallback);
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.getAggregateOperation().executeAsync(binding, new SingleResultCallback<AsyncBatchCursor<BsonDocument>>(){

                @Override
                public void onResult(AsyncBatchCursor<BsonDocument> result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        result.next(new SingleResultCallback<List<BsonDocument>>(){

                            @Override
                            public void onResult(List<BsonDocument> result, Throwable t) {
                                if (t != null) {
                                    callback.onResult(null, t);
                                } else {
                                    callback.onResult(CountOperation.this.getCountFromAggregateResults(result), null);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        if (this.countStrategy.equals((Object)CountStrategy.COMMAND)) {
            return this.createExplainableOperation(explainVerbosity);
        }
        return this.getAggregateOperation().asExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        if (this.countStrategy.equals((Object)CountStrategy.COMMAND)) {
            return this.createExplainableOperation(explainVerbosity);
        }
        return this.getAggregateOperation().asExplainableOperationAsync(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(NoOpSessionContext.INSTANCE), explainVerbosity), (Decoder<BsonDocument>)new BsonDocumentCodec());
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, Long> transformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, Long>(){

            @Override
            public Long apply(BsonDocument result, ServerAddress serverAddress) {
                return result.getNumber((Object)"n").longValue();
            }
        };
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument document = new BsonDocument("count", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, document);
        DocumentHelper.putIfNotNull(document, "query", (BsonValue)this.filter);
        DocumentHelper.putIfNotZero(document, "limit", this.limit);
        DocumentHelper.putIfNotZero(document, "skip", this.skip);
        DocumentHelper.putIfNotNull(document, "hint", this.hint);
        DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
        if (this.collation != null) {
            document.put("collation", (BsonValue)this.collation.asDocument());
        }
        return document;
    }

    private AggregateOperation<BsonDocument> getAggregateOperation() {
        return new AggregateOperation<BsonDocument>(this.namespace, this.getPipeline(), DECODER).collation(this.collation).hint(this.hint).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private List<BsonDocument> getPipeline() {
        ArrayList<BsonDocument> pipeline = new ArrayList<BsonDocument>();
        pipeline.add(new BsonDocument("$match", (BsonValue)(this.filter != null ? this.filter : new BsonDocument())));
        if (this.skip > 0L) {
            pipeline.add(new BsonDocument("$skip", (BsonValue)new BsonInt64(this.skip)));
        }
        if (this.limit > 0L) {
            pipeline.add(new BsonDocument("$limit", (BsonValue)new BsonInt64(this.limit)));
        }
        pipeline.add(new BsonDocument("$group", (BsonValue)new BsonDocument("_id", (BsonValue)new BsonNull()).append("n", (BsonValue)new BsonDocument("$sum", (BsonValue)new BsonInt32(1)))));
        return pipeline;
    }

    private Long getCountFromAggregateResults(List<BsonDocument> results) {
        if (results == null || results.isEmpty()) {
            return 0L;
        }
        return results.get(0).getNumber((Object)"n").longValue();
    }
}

