/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.util.JSONSerializers;
import com.mongodb.util.ObjectSerializer;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.data.Envelope;
import io.debezium.data.Json;
import io.debezium.function.BlockingConsumer;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.Encoder;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RecordMakers {
    private static final ObjectSerializer jsonSerializer = JSONSerializers.getStrict();
    private static final Map<String, Envelope.Operation> operationLiterals = new HashMap<String, Envelope.Operation>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create((Logger)this.logger);
    private final Filters filters;
    private final SourceInfo source;
    private final TopicSelector<CollectionId> topicSelector;
    private final Map<CollectionId, RecordsForCollection> recordMakerByCollectionId = new HashMap<CollectionId, RecordsForCollection>();
    private final Function<Document, String> valueTransformer;
    private final BlockingConsumer<SourceRecord> recorder;
    private final boolean emitTombstonesOnDelete;

    public RecordMakers(Filters filters, SourceInfo source, TopicSelector<CollectionId> topicSelector, BlockingConsumer<SourceRecord> recorder, boolean emitTombstonesOnDelete) {
        this.filters = filters;
        this.source = source;
        this.topicSelector = topicSelector;
        JsonWriterSettings writerSettings = new JsonWriterSettings(JsonMode.STRICT, "", "");
        Codec encoder = MongoClient.getDefaultCodecRegistry().get(Document.class);
        this.valueTransformer = arg_0 -> RecordMakers.lambda$new$0(writerSettings, (Encoder)encoder, arg_0);
        this.recorder = recorder;
        this.emitTombstonesOnDelete = emitTombstonesOnDelete;
    }

    public RecordsForCollection forCollection(CollectionId collectionId) {
        return this.recordMakerByCollectionId.computeIfAbsent(collectionId, id -> {
            FieldSelector.FieldFilter fieldFilter = this.filters.fieldFilterFor(collectionId);
            String topicName = this.topicSelector.topicNameFor((DataCollectionId)collectionId);
            return new RecordsForCollection(collectionId, fieldFilter, this.source, topicName, this.schemaNameAdjuster, this.valueTransformer, this.recorder, this.emitTombstonesOnDelete);
        });
    }

    public void clear() {
        this.logger.debug("Clearing table converters");
        this.recordMakerByCollectionId.clear();
    }

    private static /* synthetic */ String lambda$new$0(JsonWriterSettings writerSettings, Encoder encoder, Document doc) {
        return doc.toJson(writerSettings, encoder);
    }

    static {
        operationLiterals.put("i", Envelope.Operation.CREATE);
        operationLiterals.put("u", Envelope.Operation.UPDATE);
        operationLiterals.put("d", Envelope.Operation.DELETE);
    }

    public static final class RecordsForCollection {
        private final CollectionId collectionId;
        private final String replicaSetName;
        private final FieldSelector.FieldFilter fieldFilter;
        private final SourceInfo source;
        private final Map<String, ?> sourcePartition;
        private final String topicName;
        private final Schema keySchema;
        private final Schema valueSchema;
        private final Function<Document, String> valueTransformer;
        private final BlockingConsumer<SourceRecord> recorder;
        private final boolean emitTombstonesOnDelete;

        protected RecordsForCollection(CollectionId collectionId, FieldSelector.FieldFilter fieldFilter, SourceInfo source, String topicName, SchemaNameAdjuster adjuster, Function<Document, String> valueTransformer, BlockingConsumer<SourceRecord> recorder, boolean emitTombstonesOnDelete) {
            this.sourcePartition = source.partition(collectionId.replicaSetName());
            this.collectionId = collectionId;
            this.replicaSetName = this.collectionId.replicaSetName();
            this.fieldFilter = fieldFilter;
            this.source = source;
            this.topicName = topicName;
            this.keySchema = SchemaBuilder.struct().name(adjuster.adjust(topicName + ".Key")).field("id", Schema.STRING_SCHEMA).build();
            this.valueSchema = SchemaBuilder.struct().name(adjuster.adjust(topicName + ".Envelope")).field("after", Json.builder().optional().build()).field("patch", Json.builder().optional().build()).field("source", source.schema()).field("op", Schema.OPTIONAL_STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).build();
            this.valueTransformer = valueTransformer;
            this.recorder = recorder;
            this.emitTombstonesOnDelete = emitTombstonesOnDelete;
        }

        public CollectionId collectionId() {
            return this.collectionId;
        }

        public int recordObject(CollectionId id, Document object, long timestamp) throws InterruptedException {
            Struct sourceValue = this.source.lastSourceInfoStruct(this.replicaSetName, id);
            Map<String, ?> offset = this.source.lastOffset(this.replicaSetName);
            String objId = this.idObjToJson(object);
            assert (objId != null);
            return this.createRecords(sourceValue, offset, Envelope.Operation.READ, objId, object, timestamp);
        }

        public int recordEvent(Document oplogEvent, long timestamp) throws InterruptedException {
            String objId;
            Struct sourceValue = this.source.sourceInfoStructForEvent(this.replicaSetName, oplogEvent);
            Map<String, ?> offset = this.source.lastOffset(this.replicaSetName);
            Document patchObj = (Document)oplogEvent.get((Object)"o", Document.class);
            Object o2 = oplogEvent.get((Object)"o2");
            String string = objId = o2 != null ? this.idObjToJson(o2) : this.idObjToJson(patchObj);
            assert (objId != null);
            Envelope.Operation operation = (Envelope.Operation)operationLiterals.get(oplogEvent.getString((Object)"op"));
            return this.createRecords(sourceValue, offset, operation, objId, patchObj, timestamp);
        }

        protected int createRecords(Struct source, Map<String, ?> offset, Envelope.Operation operation, String objId, Document objectValue, long timestamp) throws InterruptedException {
            Integer partition = null;
            Struct key = this.keyFor(objId);
            Struct value = new Struct(this.valueSchema);
            switch (operation) {
                case READ: 
                case CREATE: {
                    String jsonStr = this.valueTransformer.apply(this.fieldFilter.apply(objectValue));
                    value.put("after", (Object)jsonStr);
                    break;
                }
                case UPDATE: {
                    String patchStr = this.valueTransformer.apply(this.fieldFilter.apply(objectValue));
                    value.put("patch", (Object)patchStr);
                    break;
                }
            }
            value.put("source", (Object)source);
            value.put("op", (Object)operation.code());
            value.put("ts_ms", (Object)timestamp);
            SourceRecord record = new SourceRecord(this.sourcePartition, offset, this.topicName, partition, this.keySchema, (Object)key, this.valueSchema, (Object)value);
            this.recorder.accept((Object)record);
            if (operation == Envelope.Operation.DELETE && this.emitTombstonesOnDelete) {
                record = new SourceRecord(this.sourcePartition, offset, this.topicName, partition, this.keySchema, (Object)key, null, null);
                this.recorder.accept((Object)record);
                return 2;
            }
            return 1;
        }

        protected String idObjToJson(Object idObj) {
            if (idObj == null) {
                return null;
            }
            if (!(idObj instanceof Document)) {
                return jsonSerializer.serialize(idObj);
            }
            return jsonSerializer.serialize(((Document)idObj).get((Object)"_id"));
        }

        protected Struct keyFor(String objId) {
            return new Struct(this.keySchema).put("id", (Object)objId);
        }
    }
}

