/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public abstract class RelationalDatabaseConnectorConfig
extends CommonConnectorConfig {
    public static final Field SERVER_NAME = Field.create("database.server.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired, CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName).withDescription("Unique name that identifies the database server and all recorded offsets, and that is used as a prefix for all schemas and topics. Each distinct installation should have a separate namespace and be monitored by at most one Debezium connector.");
    public static final Field TABLE_WHITELIST = Field.create("table.whitelist").withDisplayName("Included tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isListOfRegex).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create("table.blacklist").withDisplayName("Excluded tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isListOfRegex, RelationalDatabaseConnectorConfig::validateTableBlacklist).withInvisibleRecommender();
    public static final Field TABLE_IGNORE_BUILTIN = Field.create("table.ignore.builtin").withDisplayName("Ignore system databases").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(Field::isBoolean).withDescription("Flag specifying whether built-in tables should be ignored.");
    public static final Field COLUMN_BLACKLIST = Field.create("column.blacklist").withDisplayName("Exclude Columns").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field DECIMAL_HANDLING_MODE = Field.create("decimal.handling.mode").withDisplayName("Decimal Handling").withEnum(DecimalHandlingMode.class, DecimalHandlingMode.PRECISE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.");
    public static final Field SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE = Field.create("snapshot.select.statement.overrides").withDisplayName("List of tables where the default select statement used during snapshotting should be overridden.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription(" This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on thespecific connectors . Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.[DB_NAME].[TABLE_NAME]' or 'snapshot.select.statement.overrides.[SCHEMA_NAME].[TABLE_NAME]', respectively. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.");
    private final RelationalTableFilters tableFilters;

    protected RelationalDatabaseConnectorConfig(Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, int defaultSnapshotFetchSize) {
        super(config, logicalName, defaultSnapshotFetchSize);
        this.tableFilters = systemTablesFilter != null && tableIdMapper != null ? new RelationalTableFilters(config, systemTablesFilter, tableIdMapper) : null;
    }

    public RelationalTableFilters getTableFilters() {
        return this.tableFilters;
    }

    public JdbcValueConverters.DecimalMode getDecimalMode() {
        return DecimalHandlingMode.parse(this.getConfig().getString(DECIMAL_HANDLING_MODE)).asDecimalMode();
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }

    public Map<TableId, String> getSnapshotSelectOverridesByTable() {
        String tableList = this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE);
        if (tableList == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableList.split(",")) {
            snapshotSelectOverridesByTable.put(TableId.parse(table), this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table));
        }
        return Collections.unmodifiableMap(snapshotSelectOverridesByTable);
    }

    public static enum DecimalHandlingMode implements EnumeratedValue
    {
        PRECISE("precise"),
        STRING("string"),
        DOUBLE("double");

        private final String value;

        private DecimalHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public JdbcValueConverters.DecimalMode asDecimalMode() {
            switch (this) {
                case DOUBLE: {
                    return JdbcValueConverters.DecimalMode.DOUBLE;
                }
                case STRING: {
                    return JdbcValueConverters.DecimalMode.STRING;
                }
            }
            return JdbcValueConverters.DecimalMode.PRECISE;
        }

        public static DecimalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (DecimalHandlingMode option : DecimalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static DecimalHandlingMode parse(String value, String defaultValue) {
            DecimalHandlingMode mode = DecimalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = DecimalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

